// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed under the Creative Commons Public Domain, for
// any use, without warranty, 2025 by Geza Lore.
// SPDX-License-Identifier: CC0-1.0

`define signal(name, expr) wire [$bits(expr)-1:0] ``name = expr

module t (
`include "portlist.vh" // Boilerplate generated by t_dfg_break_cycles.py
  rand_a, rand_b, srand_a, srand_b
);

`include "portdecl.vh" // Boilerplate generated by t_dfg_break_cycles.py

  input rand_a;
  input rand_b;
  input srand_a;
  input srand_b;
  wire logic        [63:0] rand_a;
  wire logic        [63:0] rand_b;
  wire logic signed [63:0] srand_a;
  wire logic signed [63:0] srand_b;

  //////////////////////////////////////////////////////////////////////////

  logic concat_lhs_a;
  logic concat_lhs_b;
  always_comb begin
    {concat_lhs_a, concat_lhs_b} = rand_a[1:0] + rand_b[1:0];
  end
  `signal(CONCAT_LHS, {concat_lhs_a, concat_lhs_b});

endmodule
