# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Cascade.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class Cascade(Interface):
    idlType = "pdumodel.Cascade:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.Cascade.Info:1.0.0"
        elements = ["pduIds"]

        def __init__(self, pduIds=[]):
            for x0 in pduIds:
                typecheck.is_int(x0, AssertionError)

            self.pduIds = pduIds

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                pduIds = [x0 for x0 in json['pduIds']] if 'pduIds' in json or not useDefaults else [],
            )
            return obj

        def encode(self):
            json = {}
            json['pduIds'] = [x0 for x0 in self.pduIds]
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Cascade.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Cascade.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Cascade, self).__init__(target, agent)
        self.getInfo = Cascade._getInfo(self)

#
# Section generated by IdlC from "ResidualCurrentStateSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.sensors


# interface
class ResidualCurrentStateSensor(raritan.rpc.sensors.StateSensor):
    idlType = "pdumodel.ResidualCurrentStateSensor:2.0.7"

    STATE_NORMAL = 0

    STATE_WARNING = 1

    STATE_CRITICAL = 2

    STATE_SELFTEST = 3

    STATE_FAILURE = 4

    class _startSelfTest(Interface.Method):
        name = 'startSelfTest'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(ResidualCurrentStateSensor, self).__init__(target, agent)
        self.startSelfTest = ResidualCurrentStateSensor._startSelfTest(self)

#
# Section generated by IdlC from "Pole.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel

import raritan.rpc.sensors


# enumeration
class PowerLine(Enumeration):
    idlType = "pdumodel.PowerLine:3.0.0"
    values = ["L1", "L2", "L3", "NEUTRAL", "EARTH", "PLUS", "MINUS"]

PowerLine.L1 = PowerLine(0)
PowerLine.L2 = PowerLine(1)
PowerLine.L3 = PowerLine(2)
PowerLine.NEUTRAL = PowerLine(3)
PowerLine.EARTH = PowerLine(4)
PowerLine.PLUS = PowerLine(5)
PowerLine.MINUS = PowerLine(6)

# structure
class Pole(Structure):
    idlType = "pdumodel.Pole:11.0.0"
    elements = ["label", "line", "nodeId", "voltage", "voltageLN", "current", "peakCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "residualCurrent", "residualACCurrent", "residualDCCurrent", "crestFactor", "voltageThd", "currentThd", "residualCurrentStatus"]

    def __init__(self, label="", line=None, nodeId=0, voltage=None, voltageLN=None, current=None, peakCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, residualCurrent=None, residualACCurrent=None, residualDCCurrent=None, crestFactor=None, voltageThd=None, currentThd=None, residualCurrentStatus=None):
        if line is None:
            line = raritan.rpc.pdumodel.PowerLine.L1
        if not typecheck._is_int(label):
            typecheck.is_string(label, AssertionError)
        typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_int(nodeId, AssertionError)
        typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageLN, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualACCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualDCCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualCurrentStatus, raritan.rpc.pdumodel.ResidualCurrentStateSensor, AssertionError)

        self.label = label
        self.line = line
        self.nodeId = nodeId
        self.voltage = voltage
        self.voltageLN = voltageLN
        self.current = current
        self.peakCurrent = peakCurrent
        self.activePower = activePower
        self.reactivePower = reactivePower
        self.apparentPower = apparentPower
        self.powerFactor = powerFactor
        self.phaseAngle = phaseAngle
        self.displacementPowerFactor = displacementPowerFactor
        self.activeEnergy = activeEnergy
        self.apparentEnergy = apparentEnergy
        self.residualCurrent = residualCurrent
        self.residualACCurrent = residualACCurrent
        self.residualDCCurrent = residualDCCurrent
        self.crestFactor = crestFactor
        self.voltageThd = voltageThd
        self.currentThd = currentThd
        self.residualCurrentStatus = residualCurrentStatus

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            label = json['label'] if 'label' in json or not useDefaults else "",
            line = raritan.rpc.pdumodel.PowerLine.decode(json['line']) if 'line' in json or not useDefaults else raritan.rpc.pdumodel.PowerLine.L1,
            nodeId = json['nodeId'] if 'nodeId' in json or not useDefaults else 0,
            voltage = Interface.decode(json['voltage'], agent) if 'voltage' in json or not useDefaults else None,
            voltageLN = Interface.decode(json['voltageLN'], agent) if 'voltageLN' in json or not useDefaults else None,
            current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
            peakCurrent = Interface.decode(json['peakCurrent'], agent) if 'peakCurrent' in json or not useDefaults else None,
            activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
            reactivePower = Interface.decode(json['reactivePower'], agent) if 'reactivePower' in json or not useDefaults else None,
            apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
            powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
            phaseAngle = Interface.decode(json['phaseAngle'], agent) if 'phaseAngle' in json or not useDefaults else None,
            displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent) if 'displacementPowerFactor' in json or not useDefaults else None,
            activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
            apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
            residualCurrent = Interface.decode(json['residualCurrent'], agent) if 'residualCurrent' in json or not useDefaults else None,
            residualACCurrent = Interface.decode(json['residualACCurrent'], agent) if 'residualACCurrent' in json or not useDefaults else None,
            residualDCCurrent = Interface.decode(json['residualDCCurrent'], agent) if 'residualDCCurrent' in json or not useDefaults else None,
            crestFactor = Interface.decode(json['crestFactor'], agent) if 'crestFactor' in json or not useDefaults else None,
            voltageThd = Interface.decode(json['voltageThd'], agent) if 'voltageThd' in json or not useDefaults else None,
            currentThd = Interface.decode(json['currentThd'], agent) if 'currentThd' in json or not useDefaults else None,
            residualCurrentStatus = Interface.decode(json['residualCurrentStatus'], agent) if 'residualCurrentStatus' in json or not useDefaults else None,
        )
        return obj

    def encode(self):
        json = {}
        json['label'] = str(self.label)
        json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
        json['nodeId'] = self.nodeId
        json['voltage'] = Interface.encode(self.voltage)
        json['voltageLN'] = Interface.encode(self.voltageLN)
        json['current'] = Interface.encode(self.current)
        json['peakCurrent'] = Interface.encode(self.peakCurrent)
        json['activePower'] = Interface.encode(self.activePower)
        json['reactivePower'] = Interface.encode(self.reactivePower)
        json['apparentPower'] = Interface.encode(self.apparentPower)
        json['powerFactor'] = Interface.encode(self.powerFactor)
        json['phaseAngle'] = Interface.encode(self.phaseAngle)
        json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
        json['activeEnergy'] = Interface.encode(self.activeEnergy)
        json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
        json['residualCurrent'] = Interface.encode(self.residualCurrent)
        json['residualACCurrent'] = Interface.encode(self.residualACCurrent)
        json['residualDCCurrent'] = Interface.encode(self.residualDCCurrent)
        json['crestFactor'] = Interface.encode(self.crestFactor)
        json['voltageThd'] = Interface.encode(self.voltageThd)
        json['currentThd'] = Interface.encode(self.currentThd)
        json['residualCurrentStatus'] = Interface.encode(self.residualCurrentStatus)
        return json

# structure
class MeteredLinePair(Structure):
    idlType = "pdumodel.MeteredLinePair:4.0.0"
    elements = ["leftLine", "rightLine", "leftNodeId", "rightNodeId", "voltage", "current", "peakCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "crestFactor", "voltageThd", "currentThd"]

    def __init__(self, leftLine=None, rightLine=None, leftNodeId=0, rightNodeId=0, voltage=None, current=None, peakCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, crestFactor=None, voltageThd=None, currentThd=None):
        if leftLine is None:
            leftLine = raritan.rpc.pdumodel.PowerLine.L1
        if rightLine is None:
            rightLine = raritan.rpc.pdumodel.PowerLine.L1
        typecheck.is_enum(leftLine, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_enum(rightLine, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_int(leftNodeId, AssertionError)
        typecheck.is_int(rightNodeId, AssertionError)
        typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)

        self.leftLine = leftLine
        self.rightLine = rightLine
        self.leftNodeId = leftNodeId
        self.rightNodeId = rightNodeId
        self.voltage = voltage
        self.current = current
        self.peakCurrent = peakCurrent
        self.activePower = activePower
        self.reactivePower = reactivePower
        self.apparentPower = apparentPower
        self.powerFactor = powerFactor
        self.phaseAngle = phaseAngle
        self.displacementPowerFactor = displacementPowerFactor
        self.activeEnergy = activeEnergy
        self.apparentEnergy = apparentEnergy
        self.crestFactor = crestFactor
        self.voltageThd = voltageThd
        self.currentThd = currentThd

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            leftLine = raritan.rpc.pdumodel.PowerLine.decode(json['leftLine']) if 'leftLine' in json or not useDefaults else raritan.rpc.pdumodel.PowerLine.L1,
            rightLine = raritan.rpc.pdumodel.PowerLine.decode(json['rightLine']) if 'rightLine' in json or not useDefaults else raritan.rpc.pdumodel.PowerLine.L1,
            leftNodeId = json['leftNodeId'] if 'leftNodeId' in json or not useDefaults else 0,
            rightNodeId = json['rightNodeId'] if 'rightNodeId' in json or not useDefaults else 0,
            voltage = Interface.decode(json['voltage'], agent) if 'voltage' in json or not useDefaults else None,
            current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
            peakCurrent = Interface.decode(json['peakCurrent'], agent) if 'peakCurrent' in json or not useDefaults else None,
            activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
            reactivePower = Interface.decode(json['reactivePower'], agent) if 'reactivePower' in json or not useDefaults else None,
            apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
            powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
            phaseAngle = Interface.decode(json['phaseAngle'], agent) if 'phaseAngle' in json or not useDefaults else None,
            displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent) if 'displacementPowerFactor' in json or not useDefaults else None,
            activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
            apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
            crestFactor = Interface.decode(json['crestFactor'], agent) if 'crestFactor' in json or not useDefaults else None,
            voltageThd = Interface.decode(json['voltageThd'], agent) if 'voltageThd' in json or not useDefaults else None,
            currentThd = Interface.decode(json['currentThd'], agent) if 'currentThd' in json or not useDefaults else None,
        )
        return obj

    def encode(self):
        json = {}
        json['leftLine'] = raritan.rpc.pdumodel.PowerLine.encode(self.leftLine)
        json['rightLine'] = raritan.rpc.pdumodel.PowerLine.encode(self.rightLine)
        json['leftNodeId'] = self.leftNodeId
        json['rightNodeId'] = self.rightNodeId
        json['voltage'] = Interface.encode(self.voltage)
        json['current'] = Interface.encode(self.current)
        json['peakCurrent'] = Interface.encode(self.peakCurrent)
        json['activePower'] = Interface.encode(self.activePower)
        json['reactivePower'] = Interface.encode(self.reactivePower)
        json['apparentPower'] = Interface.encode(self.apparentPower)
        json['powerFactor'] = Interface.encode(self.powerFactor)
        json['phaseAngle'] = Interface.encode(self.phaseAngle)
        json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
        json['activeEnergy'] = Interface.encode(self.activeEnergy)
        json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
        json['crestFactor'] = Interface.encode(self.crestFactor)
        json['voltageThd'] = Interface.encode(self.voltageThd)
        json['currentThd'] = Interface.encode(self.currentThd)
        return json

# structure
class DoublePole(Structure):
    idlType = "pdumodel.DoublePole:10.0.0"
    elements = ["label", "line", "inNodeId", "outNodeId", "voltage", "voltageLN", "current", "peakCurrent", "activePower", "apparentPower", "powerFactor", "activeEnergy", "apparentEnergy"]

    def __init__(self, label="", line=None, inNodeId=0, outNodeId=0, voltage=None, voltageLN=None, current=None, peakCurrent=None, activePower=None, apparentPower=None, powerFactor=None, activeEnergy=None, apparentEnergy=None):
        if line is None:
            line = raritan.rpc.pdumodel.PowerLine.L1
        if not typecheck._is_int(label):
            typecheck.is_string(label, AssertionError)
        typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_int(inNodeId, AssertionError)
        typecheck.is_int(outNodeId, AssertionError)
        typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageLN, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)

        self.label = label
        self.line = line
        self.inNodeId = inNodeId
        self.outNodeId = outNodeId
        self.voltage = voltage
        self.voltageLN = voltageLN
        self.current = current
        self.peakCurrent = peakCurrent
        self.activePower = activePower
        self.apparentPower = apparentPower
        self.powerFactor = powerFactor
        self.activeEnergy = activeEnergy
        self.apparentEnergy = apparentEnergy

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            label = json['label'] if 'label' in json or not useDefaults else "",
            line = raritan.rpc.pdumodel.PowerLine.decode(json['line']) if 'line' in json or not useDefaults else raritan.rpc.pdumodel.PowerLine.L1,
            inNodeId = json['inNodeId'] if 'inNodeId' in json or not useDefaults else 0,
            outNodeId = json['outNodeId'] if 'outNodeId' in json or not useDefaults else 0,
            voltage = Interface.decode(json['voltage'], agent) if 'voltage' in json or not useDefaults else None,
            voltageLN = Interface.decode(json['voltageLN'], agent) if 'voltageLN' in json or not useDefaults else None,
            current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
            peakCurrent = Interface.decode(json['peakCurrent'], agent) if 'peakCurrent' in json or not useDefaults else None,
            activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
            apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
            powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
            activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
            apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
        )
        return obj

    def encode(self):
        json = {}
        json['label'] = str(self.label)
        json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
        json['inNodeId'] = self.inNodeId
        json['outNodeId'] = self.outNodeId
        json['voltage'] = Interface.encode(self.voltage)
        json['voltageLN'] = Interface.encode(self.voltageLN)
        json['current'] = Interface.encode(self.current)
        json['peakCurrent'] = Interface.encode(self.peakCurrent)
        json['activePower'] = Interface.encode(self.activePower)
        json['apparentPower'] = Interface.encode(self.apparentPower)
        json['powerFactor'] = Interface.encode(self.powerFactor)
        json['activeEnergy'] = Interface.encode(self.activeEnergy)
        json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
        return json

# structure
class ThrowPole(Structure):
    idlType = "pdumodel.ThrowPole:3.0.0"
    elements = ["label", "line", "inNodeIds", "outNodeId"]

    def __init__(self, label="", line=None, inNodeIds=[], outNodeId=0):
        if line is None:
            line = raritan.rpc.pdumodel.PowerLine.L1
        if not typecheck._is_int(label):
            typecheck.is_string(label, AssertionError)
        typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
        for x0 in inNodeIds:
            typecheck.is_int(x0, AssertionError)
        typecheck.is_int(outNodeId, AssertionError)

        self.label = label
        self.line = line
        self.inNodeIds = inNodeIds
        self.outNodeId = outNodeId

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            label = json['label'] if 'label' in json or not useDefaults else "",
            line = raritan.rpc.pdumodel.PowerLine.decode(json['line']) if 'line' in json or not useDefaults else raritan.rpc.pdumodel.PowerLine.L1,
            inNodeIds = [x0 for x0 in json['inNodeIds']] if 'inNodeIds' in json or not useDefaults else [],
            outNodeId = json['outNodeId'] if 'outNodeId' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['label'] = str(self.label)
        json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
        json['inNodeIds'] = [x0 for x0 in self.inNodeIds]
        json['outNodeId'] = self.outNodeId
        return json

#
# Section generated by IdlC from "Circuit.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class Circuit(Interface):
    idlType = "pdumodel.Circuit:2.0.3"

    ERR_INVALID_PARAM = 1

    ERR_METER_CHANNEL_BUSY = 2

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.Circuit_2_0_3.Type:1.0.0"
        values = ["ONE_PHASE_LN", "ONE_PHASE_LL", "ONE_PHASE_LLN", "THREE_PHASE"]

    Type.ONE_PHASE_LN = Type(0)
    Type.ONE_PHASE_LL = Type(1)
    Type.ONE_PHASE_LLN = Type(2)
    Type.THREE_PHASE = Type(3)

    # structure
    class Config(Structure):
        idlType = "pdumodel.Circuit_2_0_3.Config:1.0.0"
        elements = ["position", "type"]

        def __init__(self, position=0, type=None):
            if type is None:
                type = raritan.rpc.pdumodel.Circuit.Type.ONE_PHASE_LN
            typecheck.is_int(position, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.Circuit.Type, AssertionError)

            self.position = position
            self.type = type

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                position = json['position'] if 'position' in json or not useDefaults else 0,
                type = raritan.rpc.pdumodel.Circuit.Type.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.pdumodel.Circuit.Type.ONE_PHASE_LN,
            )
            return obj

        def encode(self):
            json = {}
            json['position'] = self.position
            json['type'] = raritan.rpc.pdumodel.Circuit.Type.encode(self.type)
            return json

    class _getConfig(Interface.Method):
        name = 'getConfig'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Circuit.Config.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Circuit.Config, DecodeException)
            return _ret_

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Circuit_2_0_3.Sensors:1.0.0"
        elements = ["current", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "unbalancedCurrent", "crestFactor", "activePowerDemand"]

        def __init__(self, current=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, unbalancedCurrent=None, crestFactor=None, activePowerDemand=None):
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePowerDemand, raritan.rpc.sensors.NumericSensor, AssertionError)

            self.current = current
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.phaseAngle = phaseAngle
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.unbalancedCurrent = unbalancedCurrent
            self.crestFactor = crestFactor
            self.activePowerDemand = activePowerDemand

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
                activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
                reactivePower = Interface.decode(json['reactivePower'], agent) if 'reactivePower' in json or not useDefaults else None,
                apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
                powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
                phaseAngle = Interface.decode(json['phaseAngle'], agent) if 'phaseAngle' in json or not useDefaults else None,
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent) if 'displacementPowerFactor' in json or not useDefaults else None,
                activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent) if 'unbalancedCurrent' in json or not useDefaults else None,
                crestFactor = Interface.decode(json['crestFactor'], agent) if 'crestFactor' in json or not useDefaults else None,
                activePowerDemand = Interface.decode(json['activePowerDemand'], agent) if 'activePowerDemand' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['current'] = Interface.encode(self.current)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['activePowerDemand'] = Interface.encode(self.activePowerDemand)
            return json

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Circuit.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Circuit.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.Pole.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return _ret_

    # structure
    class PoleSettings(Structure):
        idlType = "pdumodel.Circuit_2_0_3.PoleSettings:1.0.0"
        elements = ["line", "meterChannel"]

        def __init__(self, line=None, meterChannel=0):
            if line is None:
                line = raritan.rpc.pdumodel.PowerLine.L1
            typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
            typecheck.is_int(meterChannel, AssertionError)

            self.line = line
            self.meterChannel = meterChannel

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                line = raritan.rpc.pdumodel.PowerLine.decode(json['line']) if 'line' in json or not useDefaults else raritan.rpc.pdumodel.PowerLine.L1,
                meterChannel = json['meterChannel'] if 'meterChannel' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
            json['meterChannel'] = self.meterChannel
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Circuit_2_0_3.Settings:1.0.0"
        elements = ["name", "rating", "ctRating", "poleSettings"]

        def __init__(self, name="", rating=0, ctRating=0, poleSettings=[]):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            typecheck.is_int(rating, AssertionError)
            typecheck.is_int(ctRating, AssertionError)
            for x0 in poleSettings:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Circuit.PoleSettings, AssertionError)

            self.name = name
            self.rating = rating
            self.ctRating = ctRating
            self.poleSettings = poleSettings

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                rating = json['rating'] if 'rating' in json or not useDefaults else 0,
                ctRating = json['ctRating'] if 'ctRating' in json or not useDefaults else 0,
                poleSettings = [raritan.rpc.pdumodel.Circuit.PoleSettings.decode(x0, agent, useDefaults=useDefaults) for x0 in json['poleSettings']] if 'poleSettings' in json or not useDefaults else [],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['rating'] = self.rating
            json['ctRating'] = self.ctRating
            json['poleSettings'] = [raritan.rpc.pdumodel.Circuit.PoleSettings.encode(x0) for x0 in self.poleSettings]
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Circuit_2_0_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Circuit.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Circuit.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Circuit.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Circuit.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.Circuit.Settings(),
                newSettings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.Circuit.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Circuit.SettingsChangedEvent, self).listElements()
            return elements

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Circuit.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Circuit.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Circuit, self).__init__(target, agent)
        self.getConfig = Circuit._getConfig(self)
        self.getSensors = Circuit._getSensors(self)
        self.getPoles = Circuit._getPoles(self)
        self.getSettings = Circuit._getSettings(self)
        self.setSettings = Circuit._setSettings(self)

#
# Section generated by IdlC from "Controller.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.pdumodel


# structure
class CtrlStatistic(Structure):
    idlType = "pdumodel.CtrlStatistic:2.0.0"
    elements = ["mainCSumErrCnt", "subCSumErrCnt", "timeoutCnt", "resetCnt", "emResetCnt"]

    def __init__(self, mainCSumErrCnt=0, subCSumErrCnt=0, timeoutCnt=0, resetCnt=0, emResetCnt=0):
        typecheck.is_int(mainCSumErrCnt, AssertionError)
        typecheck.is_int(subCSumErrCnt, AssertionError)
        typecheck.is_int(timeoutCnt, AssertionError)
        typecheck.is_int(resetCnt, AssertionError)
        typecheck.is_int(emResetCnt, AssertionError)

        self.mainCSumErrCnt = mainCSumErrCnt
        self.subCSumErrCnt = subCSumErrCnt
        self.timeoutCnt = timeoutCnt
        self.resetCnt = resetCnt
        self.emResetCnt = emResetCnt

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            mainCSumErrCnt = json['mainCSumErrCnt'] if 'mainCSumErrCnt' in json or not useDefaults else 0,
            subCSumErrCnt = json['subCSumErrCnt'] if 'subCSumErrCnt' in json or not useDefaults else 0,
            timeoutCnt = json['timeoutCnt'] if 'timeoutCnt' in json or not useDefaults else 0,
            resetCnt = json['resetCnt'] if 'resetCnt' in json or not useDefaults else 0,
            emResetCnt = json['emResetCnt'] if 'emResetCnt' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['mainCSumErrCnt'] = self.mainCSumErrCnt
        json['subCSumErrCnt'] = self.subCSumErrCnt
        json['timeoutCnt'] = self.timeoutCnt
        json['resetCnt'] = self.resetCnt
        json['emResetCnt'] = self.emResetCnt
        return json

# interface
class Controller(Interface):
    idlType = "pdumodel.Controller:5.0.1"

    ERR_NOT_SUPPORTED = 1

    # enumeration
    class Status(Enumeration):
        idlType = "pdumodel.Controller_5_0_1.Status:1.0.0"
        values = ["OK", "COMMUNICATION_UNSTABLE", "COMMUNICATION_FAILURE", "UNKNOWN", "INCOMPATIBLE", "FIRMWARE_UPDATE"]

    Status.OK = Status(0)
    Status.COMMUNICATION_UNSTABLE = Status(1)
    Status.COMMUNICATION_FAILURE = Status(2)
    Status.UNKNOWN = Status(3)
    Status.INCOMPATIBLE = Status(4)
    Status.FIRMWARE_UPDATE = Status(5)

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.Controller_5_0_1.Type:1.0.0"
        values = ["OUTLET_CTRL", "INLET_CTRL", "METER_CTRL"]

    Type.OUTLET_CTRL = Type(0)
    Type.INLET_CTRL = Type(1)
    Type.METER_CTRL = Type(2)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Controller_5_0_1.MetaData:1.0.0"
        elements = ["type", "address", "magic", "versionAvailable", "fwAppVersion", "fwBootVersion", "hwVersion", "serial", "haveResetCnt", "haveEmResetCnt", "isOptional"]

        def __init__(self, type=None, address="", magic=0, versionAvailable=False, fwAppVersion=0, fwBootVersion=0, hwVersion=0, serial="", haveResetCnt=False, haveEmResetCnt=False, isOptional=False):
            if type is None:
                type = raritan.rpc.pdumodel.Controller.Type.OUTLET_CTRL
            typecheck.is_enum(type, raritan.rpc.pdumodel.Controller.Type, AssertionError)
            if not typecheck._is_int(address):
                typecheck.is_string(address, AssertionError)
            typecheck.is_int(magic, AssertionError)
            typecheck.is_bool(versionAvailable, AssertionError)
            typecheck.is_int(fwAppVersion, AssertionError)
            typecheck.is_int(fwBootVersion, AssertionError)
            typecheck.is_int(hwVersion, AssertionError)
            if not typecheck._is_int(serial):
                typecheck.is_string(serial, AssertionError)
            typecheck.is_bool(haveResetCnt, AssertionError)
            typecheck.is_bool(haveEmResetCnt, AssertionError)
            typecheck.is_bool(isOptional, AssertionError)

            self.type = type
            self.address = address
            self.magic = magic
            self.versionAvailable = versionAvailable
            self.fwAppVersion = fwAppVersion
            self.fwBootVersion = fwBootVersion
            self.hwVersion = hwVersion
            self.serial = serial
            self.haveResetCnt = haveResetCnt
            self.haveEmResetCnt = haveEmResetCnt
            self.isOptional = isOptional

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                type = raritan.rpc.pdumodel.Controller.Type.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.pdumodel.Controller.Type.OUTLET_CTRL,
                address = json['address'] if 'address' in json or not useDefaults else "",
                magic = json['magic'] if 'magic' in json or not useDefaults else 0,
                versionAvailable = json['versionAvailable'] if 'versionAvailable' in json or not useDefaults else False,
                fwAppVersion = json['fwAppVersion'] if 'fwAppVersion' in json or not useDefaults else 0,
                fwBootVersion = json['fwBootVersion'] if 'fwBootVersion' in json or not useDefaults else 0,
                hwVersion = json['hwVersion'] if 'hwVersion' in json or not useDefaults else 0,
                serial = json['serial'] if 'serial' in json or not useDefaults else "",
                haveResetCnt = json['haveResetCnt'] if 'haveResetCnt' in json or not useDefaults else False,
                haveEmResetCnt = json['haveEmResetCnt'] if 'haveEmResetCnt' in json or not useDefaults else False,
                isOptional = json['isOptional'] if 'isOptional' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.pdumodel.Controller.Type.encode(self.type)
            json['address'] = str(self.address)
            json['magic'] = self.magic
            json['versionAvailable'] = self.versionAvailable
            json['fwAppVersion'] = self.fwAppVersion
            json['fwBootVersion'] = self.fwBootVersion
            json['hwVersion'] = self.hwVersion
            json['serial'] = str(self.serial)
            json['haveResetCnt'] = self.haveResetCnt
            json['haveEmResetCnt'] = self.haveEmResetCnt
            json['isOptional'] = self.isOptional
            return json

    # value object
    class StatusChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Controller_5_0_1.StatusChangedEvent:1.0.0"

        def __init__(self, oldStatus=None, newStatus=None, source=None):
            super(raritan.rpc.pdumodel.Controller.StatusChangedEvent, self).__init__(source)
            if oldStatus is None:
                oldStatus = raritan.rpc.pdumodel.Controller.Status.OK
            if newStatus is None:
                newStatus = raritan.rpc.pdumodel.Controller.Status.OK
            typecheck.is_enum(oldStatus, raritan.rpc.pdumodel.Controller.Status, AssertionError)
            typecheck.is_enum(newStatus, raritan.rpc.pdumodel.Controller.Status, AssertionError)

            self.oldStatus = oldStatus
            self.newStatus = newStatus

        def encode(self):
            json = super(raritan.rpc.pdumodel.Controller.StatusChangedEvent, self).encode()
            json['oldStatus'] = raritan.rpc.pdumodel.Controller.Status.encode(self.oldStatus)
            json['newStatus'] = raritan.rpc.pdumodel.Controller.Status.encode(self.newStatus)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldStatus = raritan.rpc.pdumodel.Controller.Status.decode(json['oldStatus']) if 'oldStatus' in json or not useDefaults else raritan.rpc.pdumodel.Controller.Status.OK,
                newStatus = raritan.rpc.pdumodel.Controller.Status.decode(json['newStatus']) if 'newStatus' in json or not useDefaults else raritan.rpc.pdumodel.Controller.Status.OK,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldStatus", "newStatus"]
            elements = elements + super(raritan.rpc.pdumodel.Controller.StatusChangedEvent, self).listElements()
            return elements

    # value object
    class MetaDataChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Controller_5_0_1.MetaDataChangedEvent:1.0.0"

        def __init__(self, oldMetaData=None, newMetaData=None, source=None):
            super(raritan.rpc.pdumodel.Controller.MetaDataChangedEvent, self).__init__(source)
            if oldMetaData is None:
                oldMetaData = raritan.rpc.pdumodel.Controller.MetaData()
            if newMetaData is None:
                newMetaData = raritan.rpc.pdumodel.Controller.MetaData()
            typecheck.is_struct(oldMetaData, raritan.rpc.pdumodel.Controller.MetaData, AssertionError)
            typecheck.is_struct(newMetaData, raritan.rpc.pdumodel.Controller.MetaData, AssertionError)

            self.oldMetaData = oldMetaData
            self.newMetaData = newMetaData

        def encode(self):
            json = super(raritan.rpc.pdumodel.Controller.MetaDataChangedEvent, self).encode()
            json['oldMetaData'] = raritan.rpc.pdumodel.Controller.MetaData.encode(self.oldMetaData)
            json['newMetaData'] = raritan.rpc.pdumodel.Controller.MetaData.encode(self.newMetaData)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldMetaData = raritan.rpc.pdumodel.Controller.MetaData.decode(json['oldMetaData'], agent, useDefaults=useDefaults) if 'oldMetaData' in json or not useDefaults else raritan.rpc.pdumodel.Controller.MetaData(),
                newMetaData = raritan.rpc.pdumodel.Controller.MetaData.decode(json['newMetaData'], agent, useDefaults=useDefaults) if 'newMetaData' in json or not useDefaults else raritan.rpc.pdumodel.Controller.MetaData(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldMetaData", "newMetaData"]
            elements = elements + super(raritan.rpc.pdumodel.Controller.MetaDataChangedEvent, self).listElements()
            return elements

    class _getCommunicationStatus(Interface.Method):
        name = 'getCommunicationStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Controller.Status.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.pdumodel.Controller.Status, DecodeException)
            return _ret_

    class _getStatistics(Interface.Method):
        name = 'getStatistics'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.CtrlStatistic.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.CtrlStatistic, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Controller.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Controller.MetaData, DecodeException)
            return _ret_

    class _reset(Interface.Method):
        name = 'reset'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Controller, self).__init__(target, agent)
        self.getCommunicationStatus = Controller._getCommunicationStatus(self)
        self.getStatistics = Controller._getStatistics(self)
        self.getMetaData = Controller._getMetaData(self)
        self.reset = Controller._reset(self)

#
# Section generated by IdlC from "Waveform.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# structure
class Waveform(Structure):
    idlType = "pdumodel.Waveform:1.0.0"
    elements = ["voltage", "current", "sampleRate"]

    def __init__(self, voltage=[], current=[], sampleRate=0):
        for x0 in voltage:
            typecheck.is_double(x0, AssertionError)
        for x0 in current:
            typecheck.is_double(x0, AssertionError)
        typecheck.is_int(sampleRate, AssertionError)

        self.voltage = voltage
        self.current = current
        self.sampleRate = sampleRate

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            voltage = [x0 for x0 in json['voltage']] if 'voltage' in json or not useDefaults else [],
            current = [x0 for x0 in json['current']] if 'current' in json or not useDefaults else [],
            sampleRate = json['sampleRate'] if 'sampleRate' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['voltage'] = [x0 for x0 in self.voltage]
        json['current'] = [x0 for x0 in self.current]
        json['sampleRate'] = self.sampleRate
        return json

#
# Section generated by IdlC from "EDevice.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class EDevice(Interface):
    idlType = "pdumodel.EDevice:1.0.1"

    class _getParents(Interface.Method):
        name = 'getParents'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.EDevice, DecodeException)
            return _ret_

    class _getChildren(Interface.Method):
        name = 'getChildren'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.EDevice, DecodeException)
            return _ret_

    class _getWaveform(Interface.Method):
        name = 'getWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_

    class _getPoleWaveform(Interface.Method):
        name = 'getPoleWaveform'

        @staticmethod
        def encode(line):
            typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
            args = {}
            args['line'] = raritan.rpc.pdumodel.PowerLine.encode(line)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(EDevice, self).__init__(target, agent)
        self.getParents = EDevice._getParents(self)
        self.getChildren = EDevice._getChildren(self)
        self.getWaveform = EDevice._getWaveform(self)
        self.getPoleWaveform = EDevice._getPoleWaveform(self)

#
# Section generated by IdlC from "Nameplate.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# structure
class Rating(Structure):
    idlType = "pdumodel.Rating:2.0.0"
    elements = ["current", "decimalCurrent", "minVoltage", "maxVoltage"]

    def __init__(self, current=0, decimalCurrent=0.0, minVoltage=0, maxVoltage=0):
        typecheck.is_int(current, AssertionError)
        typecheck.is_float(decimalCurrent, AssertionError)
        typecheck.is_int(minVoltage, AssertionError)
        typecheck.is_int(maxVoltage, AssertionError)

        self.current = current
        self.decimalCurrent = decimalCurrent
        self.minVoltage = minVoltage
        self.maxVoltage = maxVoltage

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            current = json['current'] if 'current' in json or not useDefaults else 0,
            decimalCurrent = json['decimalCurrent'] if 'decimalCurrent' in json or not useDefaults else 0.0,
            minVoltage = json['minVoltage'] if 'minVoltage' in json or not useDefaults else 0,
            maxVoltage = json['maxVoltage'] if 'maxVoltage' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['current'] = self.current
        json['decimalCurrent'] = self.decimalCurrent
        json['minVoltage'] = self.minVoltage
        json['maxVoltage'] = self.maxVoltage
        return json

# structure
class Nameplate(Structure):
    idlType = "pdumodel.Nameplate:2.0.0"
    elements = ["manufacturer", "brand", "model", "partNumber", "serialNumber", "rating", "imageFileURL"]

    def __init__(self, manufacturer="", brand="", model="", partNumber="", serialNumber="", rating=None, imageFileURL=""):
        if rating is None:
            rating = raritan.rpc.pdumodel.Nameplate.Rating()
        if not typecheck._is_int(manufacturer):
            typecheck.is_string(manufacturer, AssertionError)
        if not typecheck._is_int(brand):
            typecheck.is_string(brand, AssertionError)
        if not typecheck._is_int(model):
            typecheck.is_string(model, AssertionError)
        if not typecheck._is_int(partNumber):
            typecheck.is_string(partNumber, AssertionError)
        if not typecheck._is_int(serialNumber):
            typecheck.is_string(serialNumber, AssertionError)
        typecheck.is_struct(rating, raritan.rpc.pdumodel.Nameplate.Rating, AssertionError)
        if not typecheck._is_int(imageFileURL):
            typecheck.is_string(imageFileURL, AssertionError)

        self.manufacturer = manufacturer
        self.brand = brand
        self.model = model
        self.partNumber = partNumber
        self.serialNumber = serialNumber
        self.rating = rating
        self.imageFileURL = imageFileURL

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            manufacturer = json['manufacturer'] if 'manufacturer' in json or not useDefaults else "",
            brand = json['brand'] if 'brand' in json or not useDefaults else "",
            model = json['model'] if 'model' in json or not useDefaults else "",
            partNumber = json['partNumber'] if 'partNumber' in json or not useDefaults else "",
            serialNumber = json['serialNumber'] if 'serialNumber' in json or not useDefaults else "",
            rating = raritan.rpc.pdumodel.Nameplate.Rating.decode(json['rating'], agent, useDefaults=useDefaults) if 'rating' in json or not useDefaults else raritan.rpc.pdumodel.Nameplate.Rating(),
            imageFileURL = json['imageFileURL'] if 'imageFileURL' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['manufacturer'] = str(self.manufacturer)
        json['brand'] = str(self.brand)
        json['model'] = str(self.model)
        json['partNumber'] = str(self.partNumber)
        json['serialNumber'] = str(self.serialNumber)
        json['rating'] = raritan.rpc.pdumodel.Nameplate.Rating.encode(self.rating)
        json['imageFileURL'] = str(self.imageFileURL)
        return json

    # structure
    class Rating(Structure):
        idlType = "pdumodel.Nameplate_2_0_0.Rating:1.0.0"
        elements = ["voltage", "current", "frequency", "power"]

        def __init__(self, voltage="", current="", frequency="", power=""):
            if not typecheck._is_int(voltage):
                typecheck.is_string(voltage, AssertionError)
            if not typecheck._is_int(current):
                typecheck.is_string(current, AssertionError)
            if not typecheck._is_int(frequency):
                typecheck.is_string(frequency, AssertionError)
            if not typecheck._is_int(power):
                typecheck.is_string(power, AssertionError)

            self.voltage = voltage
            self.current = current
            self.frequency = frequency
            self.power = power

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                voltage = json['voltage'] if 'voltage' in json or not useDefaults else "",
                current = json['current'] if 'current' in json or not useDefaults else "",
                frequency = json['frequency'] if 'frequency' in json or not useDefaults else "",
                power = json['power'] if 'power' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = str(self.voltage)
            json['current'] = str(self.current)
            json['frequency'] = str(self.frequency)
            json['power'] = str(self.power)
            return json

#
# Section generated by IdlC from "Inlet.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class Inlet(EDevice):
    idlType = "pdumodel.Inlet:3.0.3"

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Inlet_3_0_3.MetaData:1.0.0"
        elements = ["label", "plugType", "namePlate", "rating", "hasWaveformSupport", "isDC"]

        def __init__(self, label="", plugType="", namePlate=None, rating=None, hasWaveformSupport=False, isDC=False):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            if not typecheck._is_int(label):
                typecheck.is_string(label, AssertionError)
            if not typecheck._is_int(plugType):
                typecheck.is_string(plugType, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_bool(hasWaveformSupport, AssertionError)
            typecheck.is_bool(isDC, AssertionError)

            self.label = label
            self.plugType = plugType
            self.namePlate = namePlate
            self.rating = rating
            self.hasWaveformSupport = hasWaveformSupport
            self.isDC = isDC

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                label = json['label'] if 'label' in json or not useDefaults else "",
                plugType = json['plugType'] if 'plugType' in json or not useDefaults else "",
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent, useDefaults=useDefaults) if 'namePlate' in json or not useDefaults else raritan.rpc.pdumodel.Nameplate(),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent, useDefaults=useDefaults) if 'rating' in json or not useDefaults else raritan.rpc.pdumodel.Rating(),
                hasWaveformSupport = json['hasWaveformSupport'] if 'hasWaveformSupport' in json or not useDefaults else False,
                isDC = json['isDC'] if 'isDC' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = str(self.label)
            json['plugType'] = str(self.plugType)
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['hasWaveformSupport'] = self.hasWaveformSupport
            json['isDC'] = self.isDC
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Inlet_3_0_3.Sensors:1.0.0"
        elements = ["voltage", "current", "peakCurrent", "residualCurrent", "residualACCurrent", "residualDCCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "unbalancedCurrent", "unbalancedLineLineCurrent", "unbalancedVoltage", "unbalancedLineLineVoltage", "lineFrequency", "phaseAngle", "crestFactor", "voltageThd", "currentThd", "powerQuality", "surgeProtectorStatus", "residualCurrentStatus"]

        def __init__(self, voltage=None, current=None, peakCurrent=None, residualCurrent=None, residualACCurrent=None, residualDCCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, unbalancedCurrent=None, unbalancedLineLineCurrent=None, unbalancedVoltage=None, unbalancedLineLineVoltage=None, lineFrequency=None, phaseAngle=None, crestFactor=None, voltageThd=None, currentThd=None, powerQuality=None, surgeProtectorStatus=None, residualCurrentStatus=None):
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualACCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualDCCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedLineLineCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedVoltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedLineLineVoltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerQuality, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(surgeProtectorStatus, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(residualCurrentStatus, raritan.rpc.pdumodel.ResidualCurrentStateSensor, AssertionError)

            self.voltage = voltage
            self.current = current
            self.peakCurrent = peakCurrent
            self.residualCurrent = residualCurrent
            self.residualACCurrent = residualACCurrent
            self.residualDCCurrent = residualDCCurrent
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy
            self.unbalancedCurrent = unbalancedCurrent
            self.unbalancedLineLineCurrent = unbalancedLineLineCurrent
            self.unbalancedVoltage = unbalancedVoltage
            self.unbalancedLineLineVoltage = unbalancedLineLineVoltage
            self.lineFrequency = lineFrequency
            self.phaseAngle = phaseAngle
            self.crestFactor = crestFactor
            self.voltageThd = voltageThd
            self.currentThd = currentThd
            self.powerQuality = powerQuality
            self.surgeProtectorStatus = surgeProtectorStatus
            self.residualCurrentStatus = residualCurrentStatus

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                voltage = Interface.decode(json['voltage'], agent) if 'voltage' in json or not useDefaults else None,
                current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
                peakCurrent = Interface.decode(json['peakCurrent'], agent) if 'peakCurrent' in json or not useDefaults else None,
                residualCurrent = Interface.decode(json['residualCurrent'], agent) if 'residualCurrent' in json or not useDefaults else None,
                residualACCurrent = Interface.decode(json['residualACCurrent'], agent) if 'residualACCurrent' in json or not useDefaults else None,
                residualDCCurrent = Interface.decode(json['residualDCCurrent'], agent) if 'residualDCCurrent' in json or not useDefaults else None,
                activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
                reactivePower = Interface.decode(json['reactivePower'], agent) if 'reactivePower' in json or not useDefaults else None,
                apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
                powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent) if 'displacementPowerFactor' in json or not useDefaults else None,
                activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent) if 'unbalancedCurrent' in json or not useDefaults else None,
                unbalancedLineLineCurrent = Interface.decode(json['unbalancedLineLineCurrent'], agent) if 'unbalancedLineLineCurrent' in json or not useDefaults else None,
                unbalancedVoltage = Interface.decode(json['unbalancedVoltage'], agent) if 'unbalancedVoltage' in json or not useDefaults else None,
                unbalancedLineLineVoltage = Interface.decode(json['unbalancedLineLineVoltage'], agent) if 'unbalancedLineLineVoltage' in json or not useDefaults else None,
                lineFrequency = Interface.decode(json['lineFrequency'], agent) if 'lineFrequency' in json or not useDefaults else None,
                phaseAngle = Interface.decode(json['phaseAngle'], agent) if 'phaseAngle' in json or not useDefaults else None,
                crestFactor = Interface.decode(json['crestFactor'], agent) if 'crestFactor' in json or not useDefaults else None,
                voltageThd = Interface.decode(json['voltageThd'], agent) if 'voltageThd' in json or not useDefaults else None,
                currentThd = Interface.decode(json['currentThd'], agent) if 'currentThd' in json or not useDefaults else None,
                powerQuality = Interface.decode(json['powerQuality'], agent) if 'powerQuality' in json or not useDefaults else None,
                surgeProtectorStatus = Interface.decode(json['surgeProtectorStatus'], agent) if 'surgeProtectorStatus' in json or not useDefaults else None,
                residualCurrentStatus = Interface.decode(json['residualCurrentStatus'], agent) if 'residualCurrentStatus' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = Interface.encode(self.voltage)
            json['current'] = Interface.encode(self.current)
            json['peakCurrent'] = Interface.encode(self.peakCurrent)
            json['residualCurrent'] = Interface.encode(self.residualCurrent)
            json['residualACCurrent'] = Interface.encode(self.residualACCurrent)
            json['residualDCCurrent'] = Interface.encode(self.residualDCCurrent)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['unbalancedLineLineCurrent'] = Interface.encode(self.unbalancedLineLineCurrent)
            json['unbalancedVoltage'] = Interface.encode(self.unbalancedVoltage)
            json['unbalancedLineLineVoltage'] = Interface.encode(self.unbalancedLineLineVoltage)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['voltageThd'] = Interface.encode(self.voltageThd)
            json['currentThd'] = Interface.encode(self.currentThd)
            json['powerQuality'] = Interface.encode(self.powerQuality)
            json['surgeProtectorStatus'] = Interface.encode(self.surgeProtectorStatus)
            json['residualCurrentStatus'] = Interface.encode(self.residualCurrentStatus)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Inlet_3_0_3.Settings:1.0.0"
        elements = ["name"]

        def __init__(self, name=""):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)

            self.name = name

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Inlet_3_0_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Inlet.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Inlet.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Inlet.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Inlet.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Inlet.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Inlet.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Inlet.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Inlet.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Inlet.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.Inlet.Settings(),
                newSettings = raritan.rpc.pdumodel.Inlet.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.Inlet.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Inlet.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class EnableStateChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Inlet_3_0_3.EnableStateChangedEvent:1.0.0"

        def __init__(self, enabled=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Inlet.EnableStateChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_bool(enabled, AssertionError)

            self.enabled = enabled

        def encode(self):
            json = super(raritan.rpc.pdumodel.Inlet.EnableStateChangedEvent, self).encode()
            json['enabled'] = self.enabled
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["enabled"]
            elements = elements + super(raritan.rpc.pdumodel.Inlet.EnableStateChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Inlet.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlet.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Inlet.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlet.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.Pole.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return _ret_

    class _getLinePairs(Interface.Method):
        name = 'getLinePairs'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.MeteredLinePair.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.MeteredLinePair, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Inlet.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlet.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Inlet.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Inlet.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setEnabled(Interface.Method):
        name = 'setEnabled'

        @staticmethod
        def encode(enabled):
            typecheck.is_bool(enabled, AssertionError)
            args = {}
            args['enabled'] = enabled
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _isEnabled(Interface.Method):
        name = 'isEnabled'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Inlet, self).__init__(target, agent)
        self.getMetaData = Inlet._getMetaData(self)
        self.getSensors = Inlet._getSensors(self)
        self.getPoles = Inlet._getPoles(self)
        self.getLinePairs = Inlet._getLinePairs(self)
        self.getSettings = Inlet._getSettings(self)
        self.setSettings = Inlet._setSettings(self)
        self.setEnabled = Inlet._setEnabled(self)
        self.isEnabled = Inlet._isEnabled(self)

#
# Section generated by IdlC from "Inlets.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class Inlets(Interface):
    idlType = "pdumodel.Inlets:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.Inlets.Info:1.0.0"
        elements = ["numberOfInlets"]

        def __init__(self, numberOfInlets=0):
            typecheck.is_int(numberOfInlets, AssertionError)

            self.numberOfInlets = numberOfInlets

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                numberOfInlets = json['numberOfInlets'] if 'numberOfInlets' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['numberOfInlets'] = self.numberOfInlets
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Inlets.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlets.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Inlets, self).__init__(target, agent)
        self.getInfo = Inlets._getInfo(self)

#
# Section generated by IdlC from "MemoryMapController.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# interface
class MemoryMapController(Controller):
    idlType = "pdumodel.MemoryMapController:5.0.1"

    class _readMemory(Interface.Method):
        name = 'readMemory'

        @staticmethod
        def encode(address, size):
            typecheck.is_int(address, AssertionError)
            typecheck.is_int(size, AssertionError)
            args = {}
            args['address'] = address
            args['size'] = size
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            memory = [x0 for x0 in rsp['memory']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in memory:
                typecheck.is_byte(x0, DecodeException)
            return (_ret_, memory)

    class _writeMemory(Interface.Method):
        name = 'writeMemory'

        @staticmethod
        def encode(address, memory):
            typecheck.is_int(address, AssertionError)
            for x0 in memory:
                typecheck.is_byte(x0, AssertionError)
            args = {}
            args['address'] = address
            args['memory'] = [x0 for x0 in memory]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(MemoryMapController, self).__init__(target, agent)
        self.readMemory = MemoryMapController._readMemory(self)
        self.writeMemory = MemoryMapController._writeMemory(self)

#
# Section generated by IdlC from "OverCurrentProtector.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# structure
class CircuitBreakerStatistic(Structure):
    idlType = "pdumodel.CircuitBreakerStatistic:1.0.0"
    elements = ["tripCnt"]

    def __init__(self, tripCnt=0):
        typecheck.is_int(tripCnt, AssertionError)

        self.tripCnt = tripCnt

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            tripCnt = json['tripCnt'] if 'tripCnt' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['tripCnt'] = self.tripCnt
        return json

# interface
class OverCurrentProtector(EDevice):
    idlType = "pdumodel.OverCurrentProtector:4.0.3"

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.OverCurrentProtector_4_0_3.Type:1.0.0"
        values = ["BREAKER_1POLE", "BREAKER_2POLE", "BREAKER_3POLE", "FUSE", "FUSE_PAIR", "RCBO_2POLE", "RCBO_3POLE", "RCBO_4POLE"]

    Type.BREAKER_1POLE = Type(0)
    Type.BREAKER_2POLE = Type(1)
    Type.BREAKER_3POLE = Type(2)
    Type.FUSE = Type(3)
    Type.FUSE_PAIR = Type(4)
    Type.RCBO_2POLE = Type(5)
    Type.RCBO_3POLE = Type(6)
    Type.RCBO_4POLE = Type(7)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.OverCurrentProtector_4_0_3.MetaData:1.0.0"
        elements = ["label", "namePlate", "rating", "type", "maxTripCnt"]

        def __init__(self, label="", namePlate=None, rating=None, type=None, maxTripCnt=0):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            if type is None:
                type = raritan.rpc.pdumodel.OverCurrentProtector.Type.BREAKER_1POLE
            if not typecheck._is_int(label):
                typecheck.is_string(label, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.OverCurrentProtector.Type, AssertionError)
            typecheck.is_int(maxTripCnt, AssertionError)

            self.label = label
            self.namePlate = namePlate
            self.rating = rating
            self.type = type
            self.maxTripCnt = maxTripCnt

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                label = json['label'] if 'label' in json or not useDefaults else "",
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent, useDefaults=useDefaults) if 'namePlate' in json or not useDefaults else raritan.rpc.pdumodel.Nameplate(),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent, useDefaults=useDefaults) if 'rating' in json or not useDefaults else raritan.rpc.pdumodel.Rating(),
                type = raritan.rpc.pdumodel.OverCurrentProtector.Type.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.pdumodel.OverCurrentProtector.Type.BREAKER_1POLE,
                maxTripCnt = json['maxTripCnt'] if 'maxTripCnt' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = str(self.label)
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['type'] = raritan.rpc.pdumodel.OverCurrentProtector.Type.encode(self.type)
            json['maxTripCnt'] = self.maxTripCnt
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.OverCurrentProtector_4_0_3.Sensors:1.0.0"
        elements = ["trip", "voltage", "current", "peakCurrent", "maximumCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "displacementPowerFactor", "crestFactor", "activeEnergy", "apparentEnergy", "phaseAngle", "lineFrequency", "residualCurrent", "residualACCurrent", "residualDCCurrent", "residualCurrentStatus"]

        def __init__(self, trip=None, voltage=None, current=None, peakCurrent=None, maximumCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, displacementPowerFactor=None, crestFactor=None, activeEnergy=None, apparentEnergy=None, phaseAngle=None, lineFrequency=None, residualCurrent=None, residualACCurrent=None, residualDCCurrent=None, residualCurrentStatus=None):
            typecheck.is_interface(trip, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(maximumCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualACCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualDCCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualCurrentStatus, raritan.rpc.pdumodel.ResidualCurrentStateSensor, AssertionError)

            self.trip = trip
            self.voltage = voltage
            self.current = current
            self.peakCurrent = peakCurrent
            self.maximumCurrent = maximumCurrent
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.displacementPowerFactor = displacementPowerFactor
            self.crestFactor = crestFactor
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy
            self.phaseAngle = phaseAngle
            self.lineFrequency = lineFrequency
            self.residualCurrent = residualCurrent
            self.residualACCurrent = residualACCurrent
            self.residualDCCurrent = residualDCCurrent
            self.residualCurrentStatus = residualCurrentStatus

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                trip = Interface.decode(json['trip'], agent) if 'trip' in json or not useDefaults else None,
                voltage = Interface.decode(json['voltage'], agent) if 'voltage' in json or not useDefaults else None,
                current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
                peakCurrent = Interface.decode(json['peakCurrent'], agent) if 'peakCurrent' in json or not useDefaults else None,
                maximumCurrent = Interface.decode(json['maximumCurrent'], agent) if 'maximumCurrent' in json or not useDefaults else None,
                activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
                reactivePower = Interface.decode(json['reactivePower'], agent) if 'reactivePower' in json or not useDefaults else None,
                apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
                powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent) if 'displacementPowerFactor' in json or not useDefaults else None,
                crestFactor = Interface.decode(json['crestFactor'], agent) if 'crestFactor' in json or not useDefaults else None,
                activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
                phaseAngle = Interface.decode(json['phaseAngle'], agent) if 'phaseAngle' in json or not useDefaults else None,
                lineFrequency = Interface.decode(json['lineFrequency'], agent) if 'lineFrequency' in json or not useDefaults else None,
                residualCurrent = Interface.decode(json['residualCurrent'], agent) if 'residualCurrent' in json or not useDefaults else None,
                residualACCurrent = Interface.decode(json['residualACCurrent'], agent) if 'residualACCurrent' in json or not useDefaults else None,
                residualDCCurrent = Interface.decode(json['residualDCCurrent'], agent) if 'residualDCCurrent' in json or not useDefaults else None,
                residualCurrentStatus = Interface.decode(json['residualCurrentStatus'], agent) if 'residualCurrentStatus' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['trip'] = Interface.encode(self.trip)
            json['voltage'] = Interface.encode(self.voltage)
            json['current'] = Interface.encode(self.current)
            json['peakCurrent'] = Interface.encode(self.peakCurrent)
            json['maximumCurrent'] = Interface.encode(self.maximumCurrent)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['residualCurrent'] = Interface.encode(self.residualCurrent)
            json['residualACCurrent'] = Interface.encode(self.residualACCurrent)
            json['residualDCCurrent'] = Interface.encode(self.residualDCCurrent)
            json['residualCurrentStatus'] = Interface.encode(self.residualCurrentStatus)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.OverCurrentProtector_4_0_3.Settings:1.0.0"
        elements = ["name"]

        def __init__(self, name=""):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)

            self.name = name

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OverCurrentProtector_4_0_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OverCurrentProtector.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.OverCurrentProtector.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.OverCurrentProtector.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OverCurrentProtector.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.OverCurrentProtector.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.OverCurrentProtector.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.OverCurrentProtector.Settings(),
                newSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.OverCurrentProtector.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.OverCurrentProtector.SettingsChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtector.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtector.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtector.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtector.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.DoublePole.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.DoublePole, DecodeException)
            return _ret_

    class _getInlet(Interface.Method):
        name = 'getInlet'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.Inlet, DecodeException)
            return _ret_

    class _getOCP(Interface.Method):
        name = 'getOCP'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.OverCurrentProtector, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtector.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtector.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OverCurrentProtector.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.OverCurrentProtector.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OverCurrentProtector, self).__init__(target, agent)
        self.getMetaData = OverCurrentProtector._getMetaData(self)
        self.getSensors = OverCurrentProtector._getSensors(self)
        self.getPoles = OverCurrentProtector._getPoles(self)
        self.getInlet = OverCurrentProtector._getInlet(self)
        self.getOCP = OverCurrentProtector._getOCP(self)
        self.getSettings = OverCurrentProtector._getSettings(self)
        self.setSettings = OverCurrentProtector._setSettings(self)

#
# Section generated by IdlC from "Outlet.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# structure
class OutletStatistic(Structure):
    idlType = "pdumodel.OutletStatistic:1.0.0"
    elements = ["relayCycleCnt", "relayFailCnt"]

    def __init__(self, relayCycleCnt=0, relayFailCnt=0):
        typecheck.is_int(relayCycleCnt, AssertionError)
        typecheck.is_int(relayFailCnt, AssertionError)

        self.relayCycleCnt = relayCycleCnt
        self.relayFailCnt = relayFailCnt

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            relayCycleCnt = json['relayCycleCnt'] if 'relayCycleCnt' in json or not useDefaults else 0,
            relayFailCnt = json['relayFailCnt'] if 'relayFailCnt' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['relayCycleCnt'] = self.relayCycleCnt
        json['relayFailCnt'] = self.relayFailCnt
        return json

# interface
class Outlet(EDevice):
    idlType = "pdumodel.Outlet:3.0.3"

    ERR_OUTLET_NOT_SWITCHABLE = 1

    ERR_LOAD_SHEDDING_ACTIVE = 2

    ERR_OUTLET_DISABLED = 3

    ERR_OUTLET_NOT_OFF = 4

    ERR_RELAY_CONTROL_DISABLED = 5

    ERR_INVALID_PARAM = 1

    ERR_OPERATION_UNSUPPORTED = 1

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Outlet_3_0_3.MetaData:1.0.0"
        elements = ["label", "receptacleType", "namePlate", "rating", "isSwitchable", "isLatching", "maxRelayCycleCnt", "hasWaveformSupport", "hasServiceModeSupport"]

        def __init__(self, label="", receptacleType="", namePlate=None, rating=None, isSwitchable=False, isLatching=False, maxRelayCycleCnt=0, hasWaveformSupport=False, hasServiceModeSupport=False):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            if not typecheck._is_int(label):
                typecheck.is_string(label, AssertionError)
            if not typecheck._is_int(receptacleType):
                typecheck.is_string(receptacleType, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_bool(isSwitchable, AssertionError)
            typecheck.is_bool(isLatching, AssertionError)
            typecheck.is_int(maxRelayCycleCnt, AssertionError)
            typecheck.is_bool(hasWaveformSupport, AssertionError)
            typecheck.is_bool(hasServiceModeSupport, AssertionError)

            self.label = label
            self.receptacleType = receptacleType
            self.namePlate = namePlate
            self.rating = rating
            self.isSwitchable = isSwitchable
            self.isLatching = isLatching
            self.maxRelayCycleCnt = maxRelayCycleCnt
            self.hasWaveformSupport = hasWaveformSupport
            self.hasServiceModeSupport = hasServiceModeSupport

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                label = json['label'] if 'label' in json or not useDefaults else "",
                receptacleType = json['receptacleType'] if 'receptacleType' in json or not useDefaults else "",
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent, useDefaults=useDefaults) if 'namePlate' in json or not useDefaults else raritan.rpc.pdumodel.Nameplate(),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent, useDefaults=useDefaults) if 'rating' in json or not useDefaults else raritan.rpc.pdumodel.Rating(),
                isSwitchable = json['isSwitchable'] if 'isSwitchable' in json or not useDefaults else False,
                isLatching = json['isLatching'] if 'isLatching' in json or not useDefaults else False,
                maxRelayCycleCnt = json['maxRelayCycleCnt'] if 'maxRelayCycleCnt' in json or not useDefaults else 0,
                hasWaveformSupport = json['hasWaveformSupport'] if 'hasWaveformSupport' in json or not useDefaults else False,
                hasServiceModeSupport = json['hasServiceModeSupport'] if 'hasServiceModeSupport' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = str(self.label)
            json['receptacleType'] = str(self.receptacleType)
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['isSwitchable'] = self.isSwitchable
            json['isLatching'] = self.isLatching
            json['maxRelayCycleCnt'] = self.maxRelayCycleCnt
            json['hasWaveformSupport'] = self.hasWaveformSupport
            json['hasServiceModeSupport'] = self.hasServiceModeSupport
            return json

    # enumeration
    class PowerState(Enumeration):
        idlType = "pdumodel.Outlet_3_0_3.PowerState:1.0.0"
        values = ["PS_OFF", "PS_ON"]

    PowerState.PS_OFF = PowerState(0)
    PowerState.PS_ON = PowerState(1)

    # structure
    class LedState(Structure):
        idlType = "pdumodel.Outlet_3_0_3.LedState:1.0.0"
        elements = ["red", "green", "blinking"]

        def __init__(self, red=False, green=False, blinking=False):
            typecheck.is_bool(red, AssertionError)
            typecheck.is_bool(green, AssertionError)
            typecheck.is_bool(blinking, AssertionError)

            self.red = red
            self.green = green
            self.blinking = blinking

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                red = json['red'] if 'red' in json or not useDefaults else False,
                green = json['green'] if 'green' in json or not useDefaults else False,
                blinking = json['blinking'] if 'blinking' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['red'] = self.red
            json['green'] = self.green
            json['blinking'] = self.blinking
            return json

    # structure
    class State(Structure):
        idlType = "pdumodel.Outlet_3_0_3.State:1.0.0"
        elements = ["available", "powerState", "switchOnInProgress", "cycleInProgress", "isLoadShed", "isSuspended", "hasInrushWaveform", "inServiceMode", "ledState", "lastPowerStateChange"]

        def __init__(self, available=False, powerState=None, switchOnInProgress=False, cycleInProgress=False, isLoadShed=False, isSuspended=False, hasInrushWaveform=False, inServiceMode=False, ledState=None, lastPowerStateChange=None):
            if powerState is None:
                powerState = raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF
            if ledState is None:
                ledState = raritan.rpc.pdumodel.Outlet.LedState()
            typecheck.is_bool(available, AssertionError)
            typecheck.is_enum(powerState, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(switchOnInProgress, AssertionError)
            typecheck.is_bool(cycleInProgress, AssertionError)
            typecheck.is_bool(isLoadShed, AssertionError)
            typecheck.is_bool(isSuspended, AssertionError)
            typecheck.is_bool(hasInrushWaveform, AssertionError)
            typecheck.is_bool(inServiceMode, AssertionError)
            typecheck.is_struct(ledState, raritan.rpc.pdumodel.Outlet.LedState, AssertionError)
            typecheck.is_time(lastPowerStateChange, AssertionError)

            self.available = available
            self.powerState = powerState
            self.switchOnInProgress = switchOnInProgress
            self.cycleInProgress = cycleInProgress
            self.isLoadShed = isLoadShed
            self.isSuspended = isSuspended
            self.hasInrushWaveform = hasInrushWaveform
            self.inServiceMode = inServiceMode
            self.ledState = ledState
            self.lastPowerStateChange = lastPowerStateChange

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                available = json['available'] if 'available' in json or not useDefaults else False,
                powerState = raritan.rpc.pdumodel.Outlet.PowerState.decode(json['powerState']) if 'powerState' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF,
                switchOnInProgress = json['switchOnInProgress'] if 'switchOnInProgress' in json or not useDefaults else False,
                cycleInProgress = json['cycleInProgress'] if 'cycleInProgress' in json or not useDefaults else False,
                isLoadShed = json['isLoadShed'] if 'isLoadShed' in json or not useDefaults else False,
                isSuspended = json['isSuspended'] if 'isSuspended' in json or not useDefaults else False,
                hasInrushWaveform = json['hasInrushWaveform'] if 'hasInrushWaveform' in json or not useDefaults else False,
                inServiceMode = json['inServiceMode'] if 'inServiceMode' in json or not useDefaults else False,
                ledState = raritan.rpc.pdumodel.Outlet.LedState.decode(json['ledState'], agent, useDefaults=useDefaults) if 'ledState' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.LedState(),
                lastPowerStateChange = raritan.rpc.Time.decode(json['lastPowerStateChange']) if 'lastPowerStateChange' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['available'] = self.available
            json['powerState'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(self.powerState)
            json['switchOnInProgress'] = self.switchOnInProgress
            json['cycleInProgress'] = self.cycleInProgress
            json['isLoadShed'] = self.isLoadShed
            json['isSuspended'] = self.isSuspended
            json['hasInrushWaveform'] = self.hasInrushWaveform
            json['inServiceMode'] = self.inServiceMode
            json['ledState'] = raritan.rpc.pdumodel.Outlet.LedState.encode(self.ledState)
            json['lastPowerStateChange'] = raritan.rpc.Time.encode(self.lastPowerStateChange)
            return json

    # enumeration
    class StartupState(Enumeration):
        idlType = "pdumodel.Outlet_3_0_3.StartupState:1.0.0"
        values = ["SS_ON", "SS_OFF", "SS_LASTKNOWN", "SS_PDUDEF"]

    StartupState.SS_ON = StartupState(0)
    StartupState.SS_OFF = StartupState(1)
    StartupState.SS_LASTKNOWN = StartupState(2)
    StartupState.SS_PDUDEF = StartupState(3)

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Outlet_3_0_3.Settings:1.0.0"
        elements = ["name", "startupState", "usePduCycleDelay", "cycleDelay", "nonCritical", "sequenceDelay"]

        def __init__(self, name="", startupState=None, usePduCycleDelay=False, cycleDelay=0, nonCritical=False, sequenceDelay=0):
            if startupState is None:
                startupState = raritan.rpc.pdumodel.Outlet.StartupState.SS_ON
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            typecheck.is_enum(startupState, raritan.rpc.pdumodel.Outlet.StartupState, AssertionError)
            typecheck.is_bool(usePduCycleDelay, AssertionError)
            typecheck.is_int(cycleDelay, AssertionError)
            typecheck.is_bool(nonCritical, AssertionError)
            typecheck.is_int(sequenceDelay, AssertionError)

            self.name = name
            self.startupState = startupState
            self.usePduCycleDelay = usePduCycleDelay
            self.cycleDelay = cycleDelay
            self.nonCritical = nonCritical
            self.sequenceDelay = sequenceDelay

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                startupState = raritan.rpc.pdumodel.Outlet.StartupState.decode(json['startupState']) if 'startupState' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.StartupState.SS_ON,
                usePduCycleDelay = json['usePduCycleDelay'] if 'usePduCycleDelay' in json or not useDefaults else False,
                cycleDelay = json['cycleDelay'] if 'cycleDelay' in json or not useDefaults else 0,
                nonCritical = json['nonCritical'] if 'nonCritical' in json or not useDefaults else False,
                sequenceDelay = json['sequenceDelay'] if 'sequenceDelay' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['startupState'] = raritan.rpc.pdumodel.Outlet.StartupState.encode(self.startupState)
            json['usePduCycleDelay'] = self.usePduCycleDelay
            json['cycleDelay'] = self.cycleDelay
            json['nonCritical'] = self.nonCritical
            json['sequenceDelay'] = self.sequenceDelay
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Outlet_3_0_3.Sensors:1.0.0"
        elements = ["voltage", "current", "peakCurrent", "maximumCurrent", "unbalancedCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "phaseAngle", "lineFrequency", "crestFactor", "voltageThd", "currentThd", "inrushCurrent", "outletState"]

        def __init__(self, voltage=None, current=None, peakCurrent=None, maximumCurrent=None, unbalancedCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, phaseAngle=None, lineFrequency=None, crestFactor=None, voltageThd=None, currentThd=None, inrushCurrent=None, outletState=None):
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(maximumCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(inrushCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(outletState, raritan.rpc.sensors.StateSensor, AssertionError)

            self.voltage = voltage
            self.current = current
            self.peakCurrent = peakCurrent
            self.maximumCurrent = maximumCurrent
            self.unbalancedCurrent = unbalancedCurrent
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy
            self.phaseAngle = phaseAngle
            self.lineFrequency = lineFrequency
            self.crestFactor = crestFactor
            self.voltageThd = voltageThd
            self.currentThd = currentThd
            self.inrushCurrent = inrushCurrent
            self.outletState = outletState

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                voltage = Interface.decode(json['voltage'], agent) if 'voltage' in json or not useDefaults else None,
                current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
                peakCurrent = Interface.decode(json['peakCurrent'], agent) if 'peakCurrent' in json or not useDefaults else None,
                maximumCurrent = Interface.decode(json['maximumCurrent'], agent) if 'maximumCurrent' in json or not useDefaults else None,
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent) if 'unbalancedCurrent' in json or not useDefaults else None,
                activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
                reactivePower = Interface.decode(json['reactivePower'], agent) if 'reactivePower' in json or not useDefaults else None,
                apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
                powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent) if 'displacementPowerFactor' in json or not useDefaults else None,
                activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
                phaseAngle = Interface.decode(json['phaseAngle'], agent) if 'phaseAngle' in json or not useDefaults else None,
                lineFrequency = Interface.decode(json['lineFrequency'], agent) if 'lineFrequency' in json or not useDefaults else None,
                crestFactor = Interface.decode(json['crestFactor'], agent) if 'crestFactor' in json or not useDefaults else None,
                voltageThd = Interface.decode(json['voltageThd'], agent) if 'voltageThd' in json or not useDefaults else None,
                currentThd = Interface.decode(json['currentThd'], agent) if 'currentThd' in json or not useDefaults else None,
                inrushCurrent = Interface.decode(json['inrushCurrent'], agent) if 'inrushCurrent' in json or not useDefaults else None,
                outletState = Interface.decode(json['outletState'], agent) if 'outletState' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = Interface.encode(self.voltage)
            json['current'] = Interface.encode(self.current)
            json['peakCurrent'] = Interface.encode(self.peakCurrent)
            json['maximumCurrent'] = Interface.encode(self.maximumCurrent)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['voltageThd'] = Interface.encode(self.voltageThd)
            json['currentThd'] = Interface.encode(self.currentThd)
            json['inrushCurrent'] = Interface.encode(self.inrushCurrent)
            json['outletState'] = Interface.encode(self.outletState)
            return json

    # value object
    class PowerControlEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Outlet_3_0_3.PowerControlEvent:1.0.0"

        def __init__(self, state=None, cycle=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Outlet.PowerControlEvent, self).__init__(actUserName, actIpAddr, source)
            if state is None:
                state = raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF
            typecheck.is_enum(state, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(cycle, AssertionError)

            self.state = state
            self.cycle = cycle

        def encode(self):
            json = super(raritan.rpc.pdumodel.Outlet.PowerControlEvent, self).encode()
            json['state'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(self.state)
            json['cycle'] = self.cycle
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                state = raritan.rpc.pdumodel.Outlet.PowerState.decode(json['state']) if 'state' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF,
                cycle = json['cycle'] if 'cycle' in json or not useDefaults else False,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["state", "cycle"]
            elements = elements + super(raritan.rpc.pdumodel.Outlet.PowerControlEvent, self).listElements()
            return elements

    # value object
    class StateChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Outlet_3_0_3.StateChangedEvent:1.0.0"

        def __init__(self, oldState=None, newState=None, source=None):
            super(raritan.rpc.pdumodel.Outlet.StateChangedEvent, self).__init__(source)
            if oldState is None:
                oldState = raritan.rpc.pdumodel.Outlet.State()
            if newState is None:
                newState = raritan.rpc.pdumodel.Outlet.State()
            typecheck.is_struct(oldState, raritan.rpc.pdumodel.Outlet.State, AssertionError)
            typecheck.is_struct(newState, raritan.rpc.pdumodel.Outlet.State, AssertionError)

            self.oldState = oldState
            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.pdumodel.Outlet.StateChangedEvent, self).encode()
            json['oldState'] = raritan.rpc.pdumodel.Outlet.State.encode(self.oldState)
            json['newState'] = raritan.rpc.pdumodel.Outlet.State.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldState = raritan.rpc.pdumodel.Outlet.State.decode(json['oldState'], agent, useDefaults=useDefaults) if 'oldState' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.State(),
                newState = raritan.rpc.pdumodel.Outlet.State.decode(json['newState'], agent, useDefaults=useDefaults) if 'newState' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.State(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldState", "newState"]
            elements = elements + super(raritan.rpc.pdumodel.Outlet.StateChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Outlet_3_0_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Outlet.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Outlet.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Outlet.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Outlet.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Outlet.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Outlet.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Outlet.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Outlet.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Outlet.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.Settings(),
                newSettings = raritan.rpc.pdumodel.Outlet.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Outlet.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class ServiceModeChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Outlet_3_0_3.ServiceModeChangedEvent:1.0.0"

        def __init__(self, enabled=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Outlet.ServiceModeChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_bool(enabled, AssertionError)

            self.enabled = enabled

        def encode(self):
            json = super(raritan.rpc.pdumodel.Outlet.ServiceModeChangedEvent, self).encode()
            json['enabled'] = self.enabled
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["enabled"]
            elements = elements + super(raritan.rpc.pdumodel.Outlet.ServiceModeChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Outlet.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Outlet.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.Sensors, DecodeException)
            return _ret_

    class _getState(Interface.Method):
        name = 'getState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Outlet.State.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.State, DecodeException)
            return _ret_

    class _setPowerState(Interface.Method):
        name = 'setPowerState'

        @staticmethod
        def encode(pstate):
            typecheck.is_enum(pstate, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            args = {}
            args['pstate'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(pstate)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cyclePowerState(Interface.Method):
        name = 'cyclePowerState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Outlet.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Outlet.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Outlet.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getIOP(Interface.Method):
        name = 'getIOP'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            i = Interface.decode(rsp['i'], agent)
            o = Interface.decode(rsp['o'], agent)
            p = [raritan.rpc.pdumodel.Pole.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['p']]
            typecheck.is_interface(i, raritan.rpc.pdumodel.Inlet, DecodeException)
            typecheck.is_interface(o, raritan.rpc.pdumodel.OverCurrentProtector, DecodeException)
            for x0 in p:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return (i, o, p)

    class _getController(Interface.Method):
        name = 'getController'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.Controller, DecodeException)
            return _ret_

    class _getInrushWaveform(Interface.Method):
        name = 'getInrushWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_

    class _setServiceModeEnabled(Interface.Method):
        name = 'setServiceModeEnabled'

        @staticmethod
        def encode(enabled):
            typecheck.is_bool(enabled, AssertionError)
            args = {}
            args['enabled'] = enabled
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _unstick(Interface.Method):
        name = 'unstick'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Outlet, self).__init__(target, agent)
        self.getMetaData = Outlet._getMetaData(self)
        self.getSensors = Outlet._getSensors(self)
        self.getState = Outlet._getState(self)
        self.setPowerState = Outlet._setPowerState(self)
        self.cyclePowerState = Outlet._cyclePowerState(self)
        self.getSettings = Outlet._getSettings(self)
        self.setSettings = Outlet._setSettings(self)
        self.getIOP = Outlet._getIOP(self)
        self.getController = Outlet._getController(self)
        self.getInrushWaveform = Outlet._getInrushWaveform(self)
        self.setServiceModeEnabled = Outlet._setServiceModeEnabled(self)
        self.unstick = Outlet._unstick(self)

#
# Section generated by IdlC from "OutletGroup.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class OutletGroup(Interface):
    idlType = "pdumodel.OutletGroup:1.1.10"

    ERR_INVALID_ARGUMENT = 1

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.OutletGroup_1_1_10.Sensors:1.0.0"
        elements = ["activePower", "apparentPower", "activeEnergy", "apparentEnergy"]

        def __init__(self, activePower=None, apparentPower=None, activeEnergy=None, apparentEnergy=None):
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.AccumulatingNumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.AccumulatingNumericSensor, AssertionError)

            self.activePower = activePower
            self.apparentPower = apparentPower
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
                apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
                activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['activePower'] = Interface.encode(self.activePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.OutletGroup_1_1_10.Settings:1.0.0"
        elements = ["name", "members"]

        def __init__(self, name="", members=[]):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            for x0 in members:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Outlet, AssertionError)

            self.name = name
            self.members = members

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                members = [Interface.decode(x0, agent) for x0 in json['members']] if 'members' in json or not useDefaults else [],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['members'] = [Interface.encode(x0) for x0 in self.members]
            return json

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.OutletGroup_1_1_10.MetaData:1.0.0"
        elements = ["groupId", "uniqueId"]

        def __init__(self, groupId=0, uniqueId=0):
            typecheck.is_int(groupId, AssertionError)
            typecheck.is_int(uniqueId, AssertionError)

            self.groupId = groupId
            self.uniqueId = uniqueId

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                groupId = json['groupId'] if 'groupId' in json or not useDefaults else 0,
                uniqueId = json['uniqueId'] if 'uniqueId' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['groupId'] = self.groupId
            json['uniqueId'] = self.uniqueId
            return json

    # value object
    class SensorsChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.OutletGroup_1_1_10.SensorsChangedEvent:1.0.0"

        def __init__(self, oldSensors=None, newSensors=None, source=None):
            super(raritan.rpc.pdumodel.OutletGroup.SensorsChangedEvent, self).__init__(source)
            if oldSensors is None:
                oldSensors = raritan.rpc.pdumodel.OutletGroup.Sensors()
            if newSensors is None:
                newSensors = raritan.rpc.pdumodel.OutletGroup.Sensors()
            typecheck.is_struct(oldSensors, raritan.rpc.pdumodel.OutletGroup.Sensors, AssertionError)
            typecheck.is_struct(newSensors, raritan.rpc.pdumodel.OutletGroup.Sensors, AssertionError)

            self.oldSensors = oldSensors
            self.newSensors = newSensors

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroup.SensorsChangedEvent, self).encode()
            json['oldSensors'] = raritan.rpc.pdumodel.OutletGroup.Sensors.encode(self.oldSensors)
            json['newSensors'] = raritan.rpc.pdumodel.OutletGroup.Sensors.encode(self.newSensors)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSensors = raritan.rpc.pdumodel.OutletGroup.Sensors.decode(json['oldSensors'], agent, useDefaults=useDefaults) if 'oldSensors' in json or not useDefaults else raritan.rpc.pdumodel.OutletGroup.Sensors(),
                newSensors = raritan.rpc.pdumodel.OutletGroup.Sensors.decode(json['newSensors'], agent, useDefaults=useDefaults) if 'newSensors' in json or not useDefaults else raritan.rpc.pdumodel.OutletGroup.Sensors(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSensors", "newSensors"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroup.SensorsChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroup_1_1_10.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroup.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.OutletGroup.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.OutletGroup.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroup.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.OutletGroup.Settings(),
                newSettings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.OutletGroup.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroup.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class PowerControlEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroup_1_1_10.PowerControlEvent:1.0.0"

        def __init__(self, state=None, cycle=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroup.PowerControlEvent, self).__init__(actUserName, actIpAddr, source)
            if state is None:
                state = raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF
            typecheck.is_enum(state, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(cycle, AssertionError)

            self.state = state
            self.cycle = cycle

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroup.PowerControlEvent, self).encode()
            json['state'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(self.state)
            json['cycle'] = self.cycle
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                state = raritan.rpc.pdumodel.Outlet.PowerState.decode(json['state']) if 'state' in json or not useDefaults else raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF,
                cycle = json['cycle'] if 'cycle' in json or not useDefaults else False,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["state", "cycle"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroup.PowerControlEvent, self).listElements()
            return elements

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OutletGroup.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OutletGroup.Sensors, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OutletGroup.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OutletGroup.MetaData, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OutletGroup.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OutletGroup.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setAllOutletPowerStates(Interface.Method):
        name = 'setAllOutletPowerStates'

        @staticmethod
        def encode(pstate):
            typecheck.is_enum(pstate, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            args = {}
            args['pstate'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(pstate)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cycleAllOutletPowerStates(Interface.Method):
        name = 'cycleAllOutletPowerStates'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OutletGroup, self).__init__(target, agent)
        self.getSensors = OutletGroup._getSensors(self)
        self.getMetaData = OutletGroup._getMetaData(self)
        self.getSettings = OutletGroup._getSettings(self)
        self.setSettings = OutletGroup._setSettings(self)
        self.setAllOutletPowerStates = OutletGroup._setAllOutletPowerStates(self)
        self.cycleAllOutletPowerStates = OutletGroup._cycleAllOutletPowerStates(self)

#
# Section generated by IdlC from "OutletGroupManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class OutletGroupManager(Interface):
    idlType = "pdumodel.OutletGroupManager:1.1.10"

    ERR_INVALID_ARGUMENT = 1

    ERR_NO_SUCH_ID = 2

    ERR_MAX_GROUP_COUNT_REACHED = 3

    # value object
    class GroupCreatedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroupManager_1_1_10.GroupCreatedEvent:1.0.0"

        def __init__(self, id=0, uniqueId=0, group=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroupManager.GroupCreatedEvent, self).__init__(actUserName, actIpAddr, source)
            if settings is None:
                settings = raritan.rpc.pdumodel.OutletGroup.Settings()
            typecheck.is_int(id, AssertionError)
            typecheck.is_int(uniqueId, AssertionError)
            typecheck.is_interface(group, raritan.rpc.pdumodel.OutletGroup, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)

            self.id = id
            self.uniqueId = uniqueId
            self.group = group
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroupManager.GroupCreatedEvent, self).encode()
            json['id'] = self.id
            json['uniqueId'] = self.uniqueId
            json['group'] = Interface.encode(self.group)
            json['settings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                uniqueId = json['uniqueId'] if 'uniqueId' in json or not useDefaults else 0,
                group = Interface.decode(json['group'], agent) if 'group' in json or not useDefaults else None,
                settings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.OutletGroup.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "uniqueId", "group", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroupManager.GroupCreatedEvent, self).listElements()
            return elements

    # value object
    class GroupDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroupManager_1_1_10.GroupDeletedEvent:1.0.0"

        def __init__(self, id=0, uniqueId=0, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroupManager.GroupDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            if settings is None:
                settings = raritan.rpc.pdumodel.OutletGroup.Settings()
            typecheck.is_int(id, AssertionError)
            typecheck.is_int(uniqueId, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)

            self.id = id
            self.uniqueId = uniqueId
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroupManager.GroupDeletedEvent, self).encode()
            json['id'] = self.id
            json['uniqueId'] = self.uniqueId
            json['settings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else 0,
                uniqueId = json['uniqueId'] if 'uniqueId' in json or not useDefaults else 0,
                settings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.OutletGroup.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["id", "uniqueId", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroupManager.GroupDeletedEvent, self).listElements()
            return elements

    class _createGroup(Interface.Method):
        name = 'createGroup'

        @staticmethod
        def encode(name, members):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            for x0 in members:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Outlet, AssertionError)
            args = {}
            args['name'] = str(name)
            args['members'] = [Interface.encode(x0) for x0 in members]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            group = Interface.decode(rsp['group'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(group, raritan.rpc.pdumodel.OutletGroup, DecodeException)
            return (_ret_, group)

    class _getAllGroups(Interface.Method):
        name = 'getAllGroups'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = dict([(
                elem['key'],
                Interface.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    class _getGroup(Interface.Method):
        name = 'getGroup'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            group = Interface.decode(rsp['group'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(group, raritan.rpc.pdumodel.OutletGroup, DecodeException)
            return (_ret_, group)

    class _deleteGroup(Interface.Method):
        name = 'deleteGroup'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OutletGroupManager, self).__init__(target, agent)
        self.createGroup = OutletGroupManager._createGroup(self)
        self.getAllGroups = OutletGroupManager._getAllGroups(self)
        self.getGroup = OutletGroupManager._getGroup(self)
        self.deleteGroup = OutletGroupManager._deleteGroup(self)

#
# Section generated by IdlC from "Outlets.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class Outlets(Interface):
    idlType = "pdumodel.Outlets:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.Outlets.Info:1.0.0"
        elements = ["numberOfOutlets"]

        def __init__(self, numberOfOutlets=0):
            typecheck.is_int(numberOfOutlets, AssertionError)

            self.numberOfOutlets = numberOfOutlets

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                numberOfOutlets = json['numberOfOutlets'] if 'numberOfOutlets' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['numberOfOutlets'] = self.numberOfOutlets
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Outlets.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlets.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Outlets, self).__init__(target, agent)
        self.getInfo = Outlets._getInfo(self)

#
# Section generated by IdlC from "OverCurrentProtectorTripSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class OverCurrentProtectorTripSensor(raritan.rpc.sensors.StateSensor):
    idlType = "pdumodel.OverCurrentProtectorTripSensor:1.1.13"

    # structure
    class TripEventInformation(Structure):
        idlType = "pdumodel.OverCurrentProtectorTripSensor_1_1_13.TripEventInformation:1.0.0"
        elements = ["cause", "timestamp", "current"]

        def __init__(self, cause=None, timestamp=None, current=0.0):
            typecheck.is_interface(cause, raritan.rpc.pdumodel.Outlet, AssertionError)
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_double(current, AssertionError)

            self.cause = cause
            self.timestamp = timestamp
            self.current = current

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                cause = Interface.decode(json['cause'], agent) if 'cause' in json or not useDefaults else None,
                timestamp = raritan.rpc.Time.decode(json['timestamp']) if 'timestamp' in json or not useDefaults else None,
                current = json['current'] if 'current' in json or not useDefaults else 0.0,
            )
            return obj

        def encode(self):
            json = {}
            json['cause'] = Interface.encode(self.cause)
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['current'] = self.current
            return json

    # value object
    class TripStateChangedEvent(raritan.rpc.sensors.StateSensor.StateChangedEvent):
        idlType = "pdumodel.OverCurrentProtectorTripSensor_1_1_13.TripStateChangedEvent:1.0.0"

        def __init__(self, tripCause=None, tripInformation=None, oldState=None, newState=None, source=None):
            super(raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripStateChangedEvent, self).__init__(oldState, newState, source)
            if tripInformation is None:
                tripInformation = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation()
            typecheck.is_interface(tripCause, raritan.rpc.pdumodel.Outlet, AssertionError)
            typecheck.is_struct(tripInformation, raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation, AssertionError)

            self.tripCause = tripCause
            self.tripInformation = tripInformation

        def encode(self):
            json = super(raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripStateChangedEvent, self).encode()
            json['tripCause'] = Interface.encode(self.tripCause)
            json['tripInformation'] = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation.encode(self.tripInformation)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                tripCause = Interface.decode(json['tripCause'], agent) if 'tripCause' in json or not useDefaults else None,
                tripInformation = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation.decode(json['tripInformation'], agent, useDefaults=useDefaults) if 'tripInformation' in json or not useDefaults else raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation(),
                # for sensors.StateSensor_4_0_7.StateChangedEvent
                oldState = raritan.rpc.sensors.StateSensor.State.decode(json['oldState'], agent, useDefaults=useDefaults) if 'oldState' in json or not useDefaults else raritan.rpc.sensors.StateSensor.State(),
                newState = raritan.rpc.sensors.StateSensor.State.decode(json['newState'], agent, useDefaults=useDefaults) if 'newState' in json or not useDefaults else raritan.rpc.sensors.StateSensor.State(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["tripCause", "tripInformation"]
            elements = elements + super(raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripStateChangedEvent, self).listElements()
            return elements

    class _getTripCause(Interface.Method):
        name = 'getTripCause'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.Outlet, DecodeException)
            return _ret_

    class _getTripEventInformation(Interface.Method):
        name = 'getTripEventInformation'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation, DecodeException)
            return _ret_

    class _getTripWaveform(Interface.Method):
        name = 'getTripWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OverCurrentProtectorTripSensor, self).__init__(target, agent)
        self.getTripCause = OverCurrentProtectorTripSensor._getTripCause(self)
        self.getTripEventInformation = OverCurrentProtectorTripSensor._getTripEventInformation(self)
        self.getTripWaveform = OverCurrentProtectorTripSensor._getTripWaveform(self)

#
# Section generated by IdlC from "OverCurrentProtectors.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class OverCurrentProtectors(Interface):
    idlType = "pdumodel.OverCurrentProtectors:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.OverCurrentProtectors.Info:1.0.0"
        elements = ["numberOfOCPs"]

        def __init__(self, numberOfOCPs=0):
            typecheck.is_int(numberOfOCPs, AssertionError)

            self.numberOfOCPs = numberOfOCPs

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                numberOfOCPs = json['numberOfOCPs'] if 'numberOfOCPs' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['numberOfOCPs'] = self.numberOfOCPs
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtectors.Info.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtectors.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OverCurrentProtectors, self).__init__(target, agent)
        self.getInfo = OverCurrentProtectors._getInfo(self)

#
# Section generated by IdlC from "PowerMeter.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class PowerMeter(Interface):
    idlType = "pdumodel.PowerMeter:2.0.3"

    ERR_INVALID_PARAM = 1

    ERR_MODBUS_UNIT_IN_USE = 2

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.PowerMeter_2_0_3.Type:1.0.0"
        values = ["ONE_PHASE", "SPLIT_PHASE", "THREE_PHASE"]

    Type.ONE_PHASE = Type(0)
    Type.SPLIT_PHASE = Type(1)
    Type.THREE_PHASE = Type(2)

    # structure
    class Config(Structure):
        idlType = "pdumodel.PowerMeter_2_0_3.Config:1.0.0"
        elements = ["powerMeterId", "type"]

        def __init__(self, powerMeterId=0, type=None):
            if type is None:
                type = raritan.rpc.pdumodel.PowerMeter.Type.ONE_PHASE
            typecheck.is_int(powerMeterId, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.PowerMeter.Type, AssertionError)

            self.powerMeterId = powerMeterId
            self.type = type

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                powerMeterId = json['powerMeterId'] if 'powerMeterId' in json or not useDefaults else 0,
                type = raritan.rpc.pdumodel.PowerMeter.Type.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Type.ONE_PHASE,
            )
            return obj

        def encode(self):
            json = {}
            json['powerMeterId'] = self.powerMeterId
            json['type'] = raritan.rpc.pdumodel.PowerMeter.Type.encode(self.type)
            return json

    class _getConfig(Interface.Method):
        name = 'getConfig'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.Config.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.Config, DecodeException)
            return _ret_

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.PowerMeter_2_0_3.Sensors:1.0.0"
        elements = ["voltage", "lineFrequency", "current", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "unbalancedCurrent", "crestFactor", "activePowerDemand", "powerQuality"]

        def __init__(self, voltage=None, lineFrequency=None, current=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, unbalancedCurrent=None, crestFactor=None, activePowerDemand=None, powerQuality=None):
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePowerDemand, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerQuality, raritan.rpc.sensors.StateSensor, AssertionError)

            self.voltage = voltage
            self.lineFrequency = lineFrequency
            self.current = current
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.phaseAngle = phaseAngle
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.unbalancedCurrent = unbalancedCurrent
            self.crestFactor = crestFactor
            self.activePowerDemand = activePowerDemand
            self.powerQuality = powerQuality

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                voltage = Interface.decode(json['voltage'], agent) if 'voltage' in json or not useDefaults else None,
                lineFrequency = Interface.decode(json['lineFrequency'], agent) if 'lineFrequency' in json or not useDefaults else None,
                current = Interface.decode(json['current'], agent) if 'current' in json or not useDefaults else None,
                activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
                reactivePower = Interface.decode(json['reactivePower'], agent) if 'reactivePower' in json or not useDefaults else None,
                apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
                powerFactor = Interface.decode(json['powerFactor'], agent) if 'powerFactor' in json or not useDefaults else None,
                phaseAngle = Interface.decode(json['phaseAngle'], agent) if 'phaseAngle' in json or not useDefaults else None,
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent) if 'displacementPowerFactor' in json or not useDefaults else None,
                activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent) if 'unbalancedCurrent' in json or not useDefaults else None,
                crestFactor = Interface.decode(json['crestFactor'], agent) if 'crestFactor' in json or not useDefaults else None,
                activePowerDemand = Interface.decode(json['activePowerDemand'], agent) if 'activePowerDemand' in json or not useDefaults else None,
                powerQuality = Interface.decode(json['powerQuality'], agent) if 'powerQuality' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = Interface.encode(self.voltage)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['current'] = Interface.encode(self.current)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['activePowerDemand'] = Interface.encode(self.activePowerDemand)
            json['powerQuality'] = Interface.encode(self.powerQuality)
            return json

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.Pole.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return _ret_

    class _getControllers(Interface.Method):
        name = 'getControllers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Controller, DecodeException)
            return _ret_

    # structure
    class Settings(Structure):
        idlType = "pdumodel.PowerMeter_2_0_3.Settings:1.0.0"
        elements = ["name", "currentRating", "phaseCtRating", "neutralCtRating", "earthCtRating", "modbusUnitAddress"]

        def __init__(self, name="", currentRating=0, phaseCtRating=0, neutralCtRating=0, earthCtRating=0, modbusUnitAddress=0):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            typecheck.is_int(currentRating, AssertionError)
            typecheck.is_int(phaseCtRating, AssertionError)
            typecheck.is_int(neutralCtRating, AssertionError)
            typecheck.is_int(earthCtRating, AssertionError)
            typecheck.is_int(modbusUnitAddress, AssertionError)

            self.name = name
            self.currentRating = currentRating
            self.phaseCtRating = phaseCtRating
            self.neutralCtRating = neutralCtRating
            self.earthCtRating = earthCtRating
            self.modbusUnitAddress = modbusUnitAddress

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                currentRating = json['currentRating'] if 'currentRating' in json or not useDefaults else 0,
                phaseCtRating = json['phaseCtRating'] if 'phaseCtRating' in json or not useDefaults else 0,
                neutralCtRating = json['neutralCtRating'] if 'neutralCtRating' in json or not useDefaults else 0,
                earthCtRating = json['earthCtRating'] if 'earthCtRating' in json or not useDefaults else 0,
                modbusUnitAddress = json['modbusUnitAddress'] if 'modbusUnitAddress' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['currentRating'] = self.currentRating
            json['phaseCtRating'] = self.phaseCtRating
            json['neutralCtRating'] = self.neutralCtRating
            json['earthCtRating'] = self.earthCtRating
            json['modbusUnitAddress'] = self.modbusUnitAddress
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeter_2_0_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeter.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.PowerMeter.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.PowerMeter.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeter.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Settings(),
                newSettings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeter.SettingsChangedEvent, self).listElements()
            return elements

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    # structure
    class EnergyPulseSettings(Structure):
        idlType = "pdumodel.PowerMeter_2_0_3.EnergyPulseSettings:1.0.0"
        elements = ["pulseEnabled", "poles", "pulsesPerKWh"]

        def __init__(self, pulseEnabled=False, poles=[], pulsesPerKWh=0):
            typecheck.is_bool(pulseEnabled, AssertionError)
            for x0 in poles:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_int(pulsesPerKWh, AssertionError)

            self.pulseEnabled = pulseEnabled
            self.poles = poles
            self.pulsesPerKWh = pulsesPerKWh

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                pulseEnabled = json['pulseEnabled'] if 'pulseEnabled' in json or not useDefaults else False,
                poles = [x0 for x0 in json['poles']] if 'poles' in json or not useDefaults else [],
                pulsesPerKWh = json['pulsesPerKWh'] if 'pulsesPerKWh' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['pulseEnabled'] = self.pulseEnabled
            json['poles'] = [x0 for x0 in self.poles]
            json['pulsesPerKWh'] = self.pulsesPerKWh
            return json

    # value object
    class EnergyPulseSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeter_2_0_3.EnergyPulseSettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings(),
                newSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettingsChangedEvent, self).listElements()
            return elements

    class _getEnergyPulseSettings(Interface.Method):
        name = 'getEnergyPulseSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, DecodeException)
            return _ret_

    class _setEnergyPulseSettings(Interface.Method):
        name = 'setEnergyPulseSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(PowerMeter, self).__init__(target, agent)
        self.getConfig = PowerMeter._getConfig(self)
        self.getSensors = PowerMeter._getSensors(self)
        self.getPoles = PowerMeter._getPoles(self)
        self.getControllers = PowerMeter._getControllers(self)
        self.getSettings = PowerMeter._getSettings(self)
        self.setSettings = PowerMeter._setSettings(self)
        self.getEnergyPulseSettings = PowerMeter._getEnergyPulseSettings(self)
        self.setEnergyPulseSettings = PowerMeter._setEnergyPulseSettings(self)

#
# Section generated by IdlC from "Panel.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class Panel(PowerMeter):
    idlType = "pdumodel.Panel:2.0.3"

    # enumeration
    class LabelingScheme(Enumeration):
        idlType = "pdumodel.Panel_2_0_3.LabelingScheme:1.0.0"
        values = ["SEQUENTIAL", "ODD_EVEN"]

    LabelingScheme.SEQUENTIAL = LabelingScheme(0)
    LabelingScheme.ODD_EVEN = LabelingScheme(1)

    # structure
    class PanelSettings(Structure):
        idlType = "pdumodel.Panel_2_0_3.PanelSettings:1.0.0"
        elements = ["meterCount", "panelSize", "columns", "labelingScheme"]

        def __init__(self, meterCount=0, panelSize=0, columns=0, labelingScheme=None):
            if labelingScheme is None:
                labelingScheme = raritan.rpc.pdumodel.Panel.LabelingScheme.SEQUENTIAL
            typecheck.is_int(meterCount, AssertionError)
            typecheck.is_int(panelSize, AssertionError)
            typecheck.is_int(columns, AssertionError)
            typecheck.is_enum(labelingScheme, raritan.rpc.pdumodel.Panel.LabelingScheme, AssertionError)

            self.meterCount = meterCount
            self.panelSize = panelSize
            self.columns = columns
            self.labelingScheme = labelingScheme

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                meterCount = json['meterCount'] if 'meterCount' in json or not useDefaults else 0,
                panelSize = json['panelSize'] if 'panelSize' in json or not useDefaults else 0,
                columns = json['columns'] if 'columns' in json or not useDefaults else 0,
                labelingScheme = raritan.rpc.pdumodel.Panel.LabelingScheme.decode(json['labelingScheme']) if 'labelingScheme' in json or not useDefaults else raritan.rpc.pdumodel.Panel.LabelingScheme.SEQUENTIAL,
            )
            return obj

        def encode(self):
            json = {}
            json['meterCount'] = self.meterCount
            json['panelSize'] = self.panelSize
            json['columns'] = self.columns
            json['labelingScheme'] = raritan.rpc.pdumodel.Panel.LabelingScheme.encode(self.labelingScheme)
            return json

    # value object
    class PanelSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Panel_2_0_3.PanelSettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Panel.PanelSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Panel.PanelSettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.Panel.PanelSettings(),
                newSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.Panel.PanelSettings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Panel.PanelSettingsChangedEvent, self).listElements()
            return elements

    class _getPanelSettings(Interface.Method):
        name = 'getPanelSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Panel.PanelSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Panel.PanelSettings, DecodeException)
            return _ret_

    class _setPanelSettings(Interface.Method):
        name = 'setPanelSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getCircuits(Interface.Method):
        name = 'getCircuits'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = dict([(
                elem['key'],
                Interface.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    # value object
    class CircuitCreatedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Panel_2_0_3.CircuitCreatedEvent:1.0.0"

        def __init__(self, circuit=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Panel.CircuitCreatedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.Circuit.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.Circuit.Settings()
            typecheck.is_interface(circuit, raritan.rpc.pdumodel.Circuit, AssertionError)
            typecheck.is_struct(config, raritan.rpc.pdumodel.Circuit.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)

            self.circuit = circuit
            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Panel.CircuitCreatedEvent, self).encode()
            json['circuit'] = Interface.encode(self.circuit)
            json['config'] = raritan.rpc.pdumodel.Circuit.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                circuit = Interface.decode(json['circuit'], agent) if 'circuit' in json or not useDefaults else None,
                config = raritan.rpc.pdumodel.Circuit.Config.decode(json['config'], agent, useDefaults=useDefaults) if 'config' in json or not useDefaults else raritan.rpc.pdumodel.Circuit.Config(),
                settings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.Circuit.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["circuit", "config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.Panel.CircuitCreatedEvent, self).listElements()
            return elements

    # value object
    class CircuitDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Panel_2_0_3.CircuitDeletedEvent:1.0.0"

        def __init__(self, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Panel.CircuitDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.Circuit.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.Circuit.Settings()
            typecheck.is_struct(config, raritan.rpc.pdumodel.Circuit.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)

            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Panel.CircuitDeletedEvent, self).encode()
            json['config'] = raritan.rpc.pdumodel.Circuit.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                config = raritan.rpc.pdumodel.Circuit.Config.decode(json['config'], agent, useDefaults=useDefaults) if 'config' in json or not useDefaults else raritan.rpc.pdumodel.Circuit.Config(),
                settings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.Circuit.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.Panel.CircuitDeletedEvent, self).listElements()
            return elements

    class _createCircuit(Interface.Method):
        name = 'createCircuit'

        @staticmethod
        def encode(config, settings):
            typecheck.is_struct(config, raritan.rpc.pdumodel.Circuit.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)
            args = {}
            args['config'] = raritan.rpc.pdumodel.Circuit.Config.encode(config)
            args['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            circuit = Interface.decode(rsp['circuit'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(circuit, raritan.rpc.pdumodel.Circuit, DecodeException)
            return (_ret_, circuit)

    class _deleteCircuit(Interface.Method):
        name = 'deleteCircuit'

        @staticmethod
        def encode(position):
            typecheck.is_int(position, AssertionError)
            args = {}
            args['position'] = position
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Panel, self).__init__(target, agent)
        self.getPanelSettings = Panel._getPanelSettings(self)
        self.setPanelSettings = Panel._setPanelSettings(self)
        self.getCircuits = Panel._getCircuits(self)
        self.createCircuit = Panel._createCircuit(self)
        self.deleteCircuit = Panel._deleteCircuit(self)

#
# Section generated by IdlC from "TransferSwitchBypassStateSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.sensors


# interface
class TransferSwitchBypassStateSensor(raritan.rpc.sensors.StateSensor):
    idlType = "pdumodel.TransferSwitchBypassStateSensor:1.0.0"

    STATE_ACTIVE_INLET_MASK = 0x7

    STATE_IS_BYPASS_SELECTED = 0x8

    STATE_FAULT = 0x10

    class _acknowledgeFault(Interface.Method):
        name = 'acknowledgeFault'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(TransferSwitchBypassStateSensor, self).__init__(target, agent)
        self.acknowledgeFault = TransferSwitchBypassStateSensor._acknowledgeFault(self)

#
# Section generated by IdlC from "TransferSwitch.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class TransferSwitch(EDevice):
    idlType = "pdumodel.TransferSwitch:6.0.1"

    ERR_INVALID_PARAM = 1

    ERR_SWITCH_PREVENTED = 2

    ERR_SWITCH_FAILED = 3

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.TransferSwitch_6_0_1.Type:1.0.0"
        values = ["STS", "ATS", "HTS"]

    Type.STS = Type(0)
    Type.ATS = Type(1)
    Type.HTS = Type(2)

    # enumeration
    class TransferReason(Enumeration):
        idlType = "pdumodel.TransferSwitch_6_0_1.TransferReason:1.0.0"
        values = ["REASON_UNKNOWN", "REASON_STARTUP", "REASON_MANUAL_TRANSFER", "REASON_AUTO_RETRANSFER", "REASON_POWER_FAILURE", "REASON_POWER_QUALITY", "REASON_OVERLOAD", "REASON_OVERHEAT", "REASON_INTERNAL_FAILURE", "REASON_BYPASS_ACTIVE"]

    TransferReason.REASON_UNKNOWN = TransferReason(0)
    TransferReason.REASON_STARTUP = TransferReason(1)
    TransferReason.REASON_MANUAL_TRANSFER = TransferReason(2)
    TransferReason.REASON_AUTO_RETRANSFER = TransferReason(3)
    TransferReason.REASON_POWER_FAILURE = TransferReason(4)
    TransferReason.REASON_POWER_QUALITY = TransferReason(5)
    TransferReason.REASON_OVERLOAD = TransferReason(6)
    TransferReason.REASON_OVERHEAT = TransferReason(7)
    TransferReason.REASON_INTERNAL_FAILURE = TransferReason(8)
    TransferReason.REASON_BYPASS_ACTIVE = TransferReason(9)
    TransferReason._fallback = TransferReason.REASON_UNKNOWN

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.TransferSwitch_6_0_1.MetaData:1.0.0"
        elements = ["label", "namePlate", "rating", "type", "sourceCount"]

        def __init__(self, label="", namePlate=None, rating=None, type=None, sourceCount=0):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            if type is None:
                type = raritan.rpc.pdumodel.TransferSwitch.Type.STS
            if not typecheck._is_int(label):
                typecheck.is_string(label, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.TransferSwitch.Type, AssertionError)
            typecheck.is_int(sourceCount, AssertionError)

            self.label = label
            self.namePlate = namePlate
            self.rating = rating
            self.type = type
            self.sourceCount = sourceCount

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                label = json['label'] if 'label' in json or not useDefaults else "",
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent, useDefaults=useDefaults) if 'namePlate' in json or not useDefaults else raritan.rpc.pdumodel.Nameplate(),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent, useDefaults=useDefaults) if 'rating' in json or not useDefaults else raritan.rpc.pdumodel.Rating(),
                type = raritan.rpc.pdumodel.TransferSwitch.Type.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.pdumodel.TransferSwitch.Type.STS,
                sourceCount = json['sourceCount'] if 'sourceCount' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = str(self.label)
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['type'] = raritan.rpc.pdumodel.TransferSwitch.Type.encode(self.type)
            json['sourceCount'] = self.sourceCount
            return json

    OPERATIONAL_STATE_OFF = 0

    OPERATIONAL_STATE_NORMAL = 1

    OPERATIONAL_STATE_STANDBY = 2

    OPERATIONAL_STATE_NON_REDUNDANT = 3

    OPERATIONAL_STATE_BYPASSED = 4

    SWITCH_FAULT_I1_SHORT = 1

    SWITCH_FAULT_I1_OPEN = 2

    SWITCH_FAULT_I2_SHORT = 4

    SWITCH_FAULT_I2_OPEN = 8

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.TransferSwitch_6_0_1.Sensors:1.0.0"
        elements = ["selectedSource", "operationalState", "sourceVoltagePhaseSyncAngle", "overloadAlarm", "phaseSyncAlarm", "switchFault", "installFaultAlarm", "outputStatus", "bypassState"]

        def __init__(self, selectedSource=None, operationalState=None, sourceVoltagePhaseSyncAngle=None, overloadAlarm=None, phaseSyncAlarm=None, switchFault=None, installFaultAlarm=None, outputStatus=None, bypassState=None):
            typecheck.is_interface(selectedSource, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(operationalState, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(sourceVoltagePhaseSyncAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(overloadAlarm, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(phaseSyncAlarm, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(switchFault, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(installFaultAlarm, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(outputStatus, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(bypassState, raritan.rpc.pdumodel.TransferSwitchBypassStateSensor, AssertionError)

            self.selectedSource = selectedSource
            self.operationalState = operationalState
            self.sourceVoltagePhaseSyncAngle = sourceVoltagePhaseSyncAngle
            self.overloadAlarm = overloadAlarm
            self.phaseSyncAlarm = phaseSyncAlarm
            self.switchFault = switchFault
            self.installFaultAlarm = installFaultAlarm
            self.outputStatus = outputStatus
            self.bypassState = bypassState

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                selectedSource = Interface.decode(json['selectedSource'], agent) if 'selectedSource' in json or not useDefaults else None,
                operationalState = Interface.decode(json['operationalState'], agent) if 'operationalState' in json or not useDefaults else None,
                sourceVoltagePhaseSyncAngle = Interface.decode(json['sourceVoltagePhaseSyncAngle'], agent) if 'sourceVoltagePhaseSyncAngle' in json or not useDefaults else None,
                overloadAlarm = Interface.decode(json['overloadAlarm'], agent) if 'overloadAlarm' in json or not useDefaults else None,
                phaseSyncAlarm = Interface.decode(json['phaseSyncAlarm'], agent) if 'phaseSyncAlarm' in json or not useDefaults else None,
                switchFault = Interface.decode(json['switchFault'], agent) if 'switchFault' in json or not useDefaults else None,
                installFaultAlarm = Interface.decode(json['installFaultAlarm'], agent) if 'installFaultAlarm' in json or not useDefaults else None,
                outputStatus = Interface.decode(json['outputStatus'], agent) if 'outputStatus' in json or not useDefaults else None,
                bypassState = Interface.decode(json['bypassState'], agent) if 'bypassState' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['selectedSource'] = Interface.encode(self.selectedSource)
            json['operationalState'] = Interface.encode(self.operationalState)
            json['sourceVoltagePhaseSyncAngle'] = Interface.encode(self.sourceVoltagePhaseSyncAngle)
            json['overloadAlarm'] = Interface.encode(self.overloadAlarm)
            json['phaseSyncAlarm'] = Interface.encode(self.phaseSyncAlarm)
            json['switchFault'] = Interface.encode(self.switchFault)
            json['installFaultAlarm'] = Interface.encode(self.installFaultAlarm)
            json['outputStatus'] = Interface.encode(self.outputStatus)
            json['bypassState'] = Interface.encode(self.bypassState)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.TransferSwitch_6_0_1.Settings:1.0.0"
        elements = ["name", "preferredSource", "autoRetransfer", "noAutoRetransferIfPhaseFault", "autoRetransferWaitTime", "manualTransferEnabled", "phaseSyncSensorEnabled"]

        def __init__(self, name="", preferredSource=0, autoRetransfer=False, noAutoRetransferIfPhaseFault=False, autoRetransferWaitTime=0, manualTransferEnabled=False, phaseSyncSensorEnabled=False):
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            typecheck.is_int(preferredSource, AssertionError)
            typecheck.is_bool(autoRetransfer, AssertionError)
            typecheck.is_bool(noAutoRetransferIfPhaseFault, AssertionError)
            typecheck.is_int(autoRetransferWaitTime, AssertionError)
            typecheck.is_bool(manualTransferEnabled, AssertionError)
            typecheck.is_bool(phaseSyncSensorEnabled, AssertionError)

            self.name = name
            self.preferredSource = preferredSource
            self.autoRetransfer = autoRetransfer
            self.noAutoRetransferIfPhaseFault = noAutoRetransferIfPhaseFault
            self.autoRetransferWaitTime = autoRetransferWaitTime
            self.manualTransferEnabled = manualTransferEnabled
            self.phaseSyncSensorEnabled = phaseSyncSensorEnabled

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                preferredSource = json['preferredSource'] if 'preferredSource' in json or not useDefaults else 0,
                autoRetransfer = json['autoRetransfer'] if 'autoRetransfer' in json or not useDefaults else False,
                noAutoRetransferIfPhaseFault = json['noAutoRetransferIfPhaseFault'] if 'noAutoRetransferIfPhaseFault' in json or not useDefaults else False,
                autoRetransferWaitTime = json['autoRetransferWaitTime'] if 'autoRetransferWaitTime' in json or not useDefaults else 0,
                manualTransferEnabled = json['manualTransferEnabled'] if 'manualTransferEnabled' in json or not useDefaults else False,
                phaseSyncSensorEnabled = json['phaseSyncSensorEnabled'] if 'phaseSyncSensorEnabled' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['preferredSource'] = self.preferredSource
            json['autoRetransfer'] = self.autoRetransfer
            json['noAutoRetransferIfPhaseFault'] = self.noAutoRetransferIfPhaseFault
            json['autoRetransferWaitTime'] = self.autoRetransferWaitTime
            json['manualTransferEnabled'] = self.manualTransferEnabled
            json['phaseSyncSensorEnabled'] = self.phaseSyncSensorEnabled
            return json

    # structure
    class Statistics(Structure):
        idlType = "pdumodel.TransferSwitch_6_0_1.Statistics:1.0.0"
        elements = ["transferCount", "powerFailDetectTime", "relayOpenTime", "totalTransferTime"]

        def __init__(self, transferCount=0, powerFailDetectTime=0, relayOpenTime=0, totalTransferTime=0):
            typecheck.is_int(transferCount, AssertionError)
            typecheck.is_int(powerFailDetectTime, AssertionError)
            typecheck.is_int(relayOpenTime, AssertionError)
            typecheck.is_int(totalTransferTime, AssertionError)

            self.transferCount = transferCount
            self.powerFailDetectTime = powerFailDetectTime
            self.relayOpenTime = relayOpenTime
            self.totalTransferTime = totalTransferTime

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                transferCount = json['transferCount'] if 'transferCount' in json or not useDefaults else 0,
                powerFailDetectTime = json['powerFailDetectTime'] if 'powerFailDetectTime' in json or not useDefaults else 0,
                relayOpenTime = json['relayOpenTime'] if 'relayOpenTime' in json or not useDefaults else 0,
                totalTransferTime = json['totalTransferTime'] if 'totalTransferTime' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['transferCount'] = self.transferCount
            json['powerFailDetectTime'] = self.powerFailDetectTime
            json['relayOpenTime'] = self.relayOpenTime
            json['totalTransferTime'] = self.totalTransferTime
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.TransferSwitch_6_0_1.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.TransferSwitch.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.TransferSwitch.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.TransferSwitch.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.TransferSwitch.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.TransferSwitch.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.TransferSwitch.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.TransferSwitch.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.TransferSwitch.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.TransferSwitch.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.TransferSwitch.Settings(),
                newSettings = raritan.rpc.pdumodel.TransferSwitch.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.TransferSwitch.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.TransferSwitch.SettingsChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.ThrowPole.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.ThrowPole, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.TransferSwitch.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.TransferSwitch.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getStatistics(Interface.Method):
        name = 'getStatistics'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.Statistics.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.Statistics, DecodeException)
            return _ret_

    class _transferToSource(Interface.Method):
        name = 'transferToSource'

        @staticmethod
        def encode(source, faultOverride):
            typecheck.is_int(source, AssertionError)
            typecheck.is_bool(faultOverride, AssertionError)
            args = {}
            args['source'] = source
            args['faultOverride'] = faultOverride
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getLastTransferReason(Interface.Method):
        name = 'getLastTransferReason'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.TransferReason.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.pdumodel.TransferSwitch.TransferReason, DecodeException)
            return _ret_

    class _getLastTransferWaveform(Interface.Method):
        name = 'getLastTransferWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_

    # structure
    class TransferLogEntry(Structure):
        idlType = "pdumodel.TransferSwitch_6_0_1.TransferLogEntry:1.0.0"
        elements = ["timestamp", "oldInlet", "newInlet", "reason", "waveform", "statistics", "switchFault"]

        def __init__(self, timestamp=None, oldInlet=0, newInlet=0, reason=None, waveform=None, statistics=None, switchFault=0):
            if reason is None:
                reason = raritan.rpc.pdumodel.TransferSwitch.TransferReason.REASON_UNKNOWN
            if waveform is None:
                waveform = raritan.rpc.pdumodel.Waveform()
            if statistics is None:
                statistics = raritan.rpc.pdumodel.TransferSwitch.Statistics()
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_int(oldInlet, AssertionError)
            typecheck.is_int(newInlet, AssertionError)
            typecheck.is_enum(reason, raritan.rpc.pdumodel.TransferSwitch.TransferReason, AssertionError)
            typecheck.is_struct(waveform, raritan.rpc.pdumodel.Waveform, AssertionError)
            typecheck.is_struct(statistics, raritan.rpc.pdumodel.TransferSwitch.Statistics, AssertionError)
            typecheck.is_int(switchFault, AssertionError)

            self.timestamp = timestamp
            self.oldInlet = oldInlet
            self.newInlet = newInlet
            self.reason = reason
            self.waveform = waveform
            self.statistics = statistics
            self.switchFault = switchFault

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                timestamp = raritan.rpc.Time.decode(json['timestamp']) if 'timestamp' in json or not useDefaults else None,
                oldInlet = json['oldInlet'] if 'oldInlet' in json or not useDefaults else 0,
                newInlet = json['newInlet'] if 'newInlet' in json or not useDefaults else 0,
                reason = raritan.rpc.pdumodel.TransferSwitch.TransferReason.decode(json['reason']) if 'reason' in json or not useDefaults else raritan.rpc.pdumodel.TransferSwitch.TransferReason.REASON_UNKNOWN,
                waveform = raritan.rpc.pdumodel.Waveform.decode(json['waveform'], agent, useDefaults=useDefaults) if 'waveform' in json or not useDefaults else raritan.rpc.pdumodel.Waveform(),
                statistics = raritan.rpc.pdumodel.TransferSwitch.Statistics.decode(json['statistics'], agent, useDefaults=useDefaults) if 'statistics' in json or not useDefaults else raritan.rpc.pdumodel.TransferSwitch.Statistics(),
                switchFault = json['switchFault'] if 'switchFault' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['oldInlet'] = self.oldInlet
            json['newInlet'] = self.newInlet
            json['reason'] = raritan.rpc.pdumodel.TransferSwitch.TransferReason.encode(self.reason)
            json['waveform'] = raritan.rpc.pdumodel.Waveform.encode(self.waveform)
            json['statistics'] = raritan.rpc.pdumodel.TransferSwitch.Statistics.encode(self.statistics)
            json['switchFault'] = self.switchFault
            return json

    class _getTransferLog(Interface.Method):
        name = 'getTransferLog'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.TransferSwitch.TransferLogEntry.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.TransferSwitch.TransferLogEntry, DecodeException)
            return _ret_

    class _getParameters(Interface.Method):
        name = 'getParameters'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = dict([(
                elem['key'],
                elem['value'])
                for elem in rsp['_ret_']])
            return _ret_

    class _setParameters(Interface.Method):
        name = 'setParameters'

        @staticmethod
        def encode(parameters):
            args = {}
            args['parameters'] = [dict(
                key = str(k),
                value = v)
                for k, v in parameters.items()]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(TransferSwitch, self).__init__(target, agent)
        self.getMetaData = TransferSwitch._getMetaData(self)
        self.getSensors = TransferSwitch._getSensors(self)
        self.getPoles = TransferSwitch._getPoles(self)
        self.getSettings = TransferSwitch._getSettings(self)
        self.setSettings = TransferSwitch._setSettings(self)
        self.getStatistics = TransferSwitch._getStatistics(self)
        self.transferToSource = TransferSwitch._transferToSource(self)
        self.getLastTransferReason = TransferSwitch._getLastTransferReason(self)
        self.getLastTransferWaveform = TransferSwitch._getLastTransferWaveform(self)
        self.getTransferLog = TransferSwitch._getTransferLog(self)
        self.getParameters = TransferSwitch._getParameters(self)
        self.setParameters = TransferSwitch._setParameters(self)

#
# Section generated by IdlC from "Pdu.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.hmi

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.peripheral

import raritan.rpc.portsmodel

import raritan.rpc.sensors


# interface
class Pdu(Interface):
    idlType = "pdumodel.Pdu:6.5.5"

    ERR_INVALID_PARAM = 1

    # enumeration
    class PduOrientation(Enumeration):
        idlType = "pdumodel.Pdu_6_5_5.PduOrientation:1.0.0"
        values = ["PO_NONE", "PO_BOTTOMFEED", "PO_TOPFEED"]

    PduOrientation.PO_NONE = PduOrientation(0)
    PduOrientation.PO_BOTTOMFEED = PduOrientation(1)
    PduOrientation.PO_TOPFEED = PduOrientation(2)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Pdu_6_5_5.MetaData:1.0.0"
        elements = ["nameplate", "ctrlBoardSerial", "hwRevision", "fwRevision", "macAddress", "hasSwitchableOutlets", "hasMeteredOutlets", "hasLatchingOutletRelays", "isInlineMeter", "isEnergyPulseSupported", "hasDCInlets", "pduOrientation"]

        def __init__(self, nameplate=None, ctrlBoardSerial="", hwRevision="", fwRevision="", macAddress="", hasSwitchableOutlets=False, hasMeteredOutlets=False, hasLatchingOutletRelays=False, isInlineMeter=False, isEnergyPulseSupported=False, hasDCInlets=False, pduOrientation=None):
            if nameplate is None:
                nameplate = raritan.rpc.pdumodel.Nameplate()
            if pduOrientation is None:
                pduOrientation = raritan.rpc.pdumodel.Pdu.PduOrientation.PO_NONE
            typecheck.is_struct(nameplate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            if not typecheck._is_int(ctrlBoardSerial):
                typecheck.is_string(ctrlBoardSerial, AssertionError)
            if not typecheck._is_int(hwRevision):
                typecheck.is_string(hwRevision, AssertionError)
            if not typecheck._is_int(fwRevision):
                typecheck.is_string(fwRevision, AssertionError)
            if not typecheck._is_int(macAddress):
                typecheck.is_string(macAddress, AssertionError)
            typecheck.is_bool(hasSwitchableOutlets, AssertionError)
            typecheck.is_bool(hasMeteredOutlets, AssertionError)
            typecheck.is_bool(hasLatchingOutletRelays, AssertionError)
            typecheck.is_bool(isInlineMeter, AssertionError)
            typecheck.is_bool(isEnergyPulseSupported, AssertionError)
            typecheck.is_bool(hasDCInlets, AssertionError)
            typecheck.is_enum(pduOrientation, raritan.rpc.pdumodel.Pdu.PduOrientation, AssertionError)

            self.nameplate = nameplate
            self.ctrlBoardSerial = ctrlBoardSerial
            self.hwRevision = hwRevision
            self.fwRevision = fwRevision
            self.macAddress = macAddress
            self.hasSwitchableOutlets = hasSwitchableOutlets
            self.hasMeteredOutlets = hasMeteredOutlets
            self.hasLatchingOutletRelays = hasLatchingOutletRelays
            self.isInlineMeter = isInlineMeter
            self.isEnergyPulseSupported = isEnergyPulseSupported
            self.hasDCInlets = hasDCInlets
            self.pduOrientation = pduOrientation

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                nameplate = raritan.rpc.pdumodel.Nameplate.decode(json['nameplate'], agent, useDefaults=useDefaults) if 'nameplate' in json or not useDefaults else raritan.rpc.pdumodel.Nameplate(),
                ctrlBoardSerial = json['ctrlBoardSerial'] if 'ctrlBoardSerial' in json or not useDefaults else "",
                hwRevision = json['hwRevision'] if 'hwRevision' in json or not useDefaults else "",
                fwRevision = json['fwRevision'] if 'fwRevision' in json or not useDefaults else "",
                macAddress = json['macAddress'] if 'macAddress' in json or not useDefaults else "",
                hasSwitchableOutlets = json['hasSwitchableOutlets'] if 'hasSwitchableOutlets' in json or not useDefaults else False,
                hasMeteredOutlets = json['hasMeteredOutlets'] if 'hasMeteredOutlets' in json or not useDefaults else False,
                hasLatchingOutletRelays = json['hasLatchingOutletRelays'] if 'hasLatchingOutletRelays' in json or not useDefaults else False,
                isInlineMeter = json['isInlineMeter'] if 'isInlineMeter' in json or not useDefaults else False,
                isEnergyPulseSupported = json['isEnergyPulseSupported'] if 'isEnergyPulseSupported' in json or not useDefaults else False,
                hasDCInlets = json['hasDCInlets'] if 'hasDCInlets' in json or not useDefaults else False,
                pduOrientation = raritan.rpc.pdumodel.Pdu.PduOrientation.decode(json['pduOrientation']) if 'pduOrientation' in json or not useDefaults else raritan.rpc.pdumodel.Pdu.PduOrientation.PO_NONE,
            )
            return obj

        def encode(self):
            json = {}
            json['nameplate'] = raritan.rpc.pdumodel.Nameplate.encode(self.nameplate)
            json['ctrlBoardSerial'] = str(self.ctrlBoardSerial)
            json['hwRevision'] = str(self.hwRevision)
            json['fwRevision'] = str(self.fwRevision)
            json['macAddress'] = str(self.macAddress)
            json['hasSwitchableOutlets'] = self.hasSwitchableOutlets
            json['hasMeteredOutlets'] = self.hasMeteredOutlets
            json['hasLatchingOutletRelays'] = self.hasLatchingOutletRelays
            json['isInlineMeter'] = self.isInlineMeter
            json['isEnergyPulseSupported'] = self.isEnergyPulseSupported
            json['hasDCInlets'] = self.hasDCInlets
            json['pduOrientation'] = raritan.rpc.pdumodel.Pdu.PduOrientation.encode(self.pduOrientation)
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Pdu_6_5_5.Sensors:1.0.0"
        elements = ["powerSupplyStatus", "activePower", "apparentPower", "activeEnergy", "apparentEnergy"]

        def __init__(self, powerSupplyStatus=[], activePower=None, apparentPower=None, activeEnergy=None, apparentEnergy=None):
            for x0 in powerSupplyStatus:
                typecheck.is_interface(x0, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)

            self.powerSupplyStatus = powerSupplyStatus
            self.activePower = activePower
            self.apparentPower = apparentPower
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                powerSupplyStatus = [Interface.decode(x0, agent) for x0 in json['powerSupplyStatus']] if 'powerSupplyStatus' in json or not useDefaults else [],
                activePower = Interface.decode(json['activePower'], agent) if 'activePower' in json or not useDefaults else None,
                apparentPower = Interface.decode(json['apparentPower'], agent) if 'apparentPower' in json or not useDefaults else None,
                activeEnergy = Interface.decode(json['activeEnergy'], agent) if 'activeEnergy' in json or not useDefaults else None,
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent) if 'apparentEnergy' in json or not useDefaults else None,
            )
            return obj

        def encode(self):
            json = {}
            json['powerSupplyStatus'] = [Interface.encode(x0) for x0 in self.powerSupplyStatus]
            json['activePower'] = Interface.encode(self.activePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            return json

    # structure
    class Statistic(Structure):
        idlType = "pdumodel.Pdu_6_5_5.Statistic:1.0.0"
        elements = ["cbStats", "ctrlStats", "outletStats", "peripheralStats"]

        def __init__(self, cbStats=[], ctrlStats=[], outletStats=[], peripheralStats=None):
            if peripheralStats is None:
                peripheralStats = raritan.rpc.peripheral.DeviceManager.Statistics()
            for x0 in cbStats:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.CircuitBreakerStatistic, AssertionError)
            for x0 in ctrlStats:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.CtrlStatistic, AssertionError)
            for x0 in outletStats:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.OutletStatistic, AssertionError)
            typecheck.is_struct(peripheralStats, raritan.rpc.peripheral.DeviceManager.Statistics, AssertionError)

            self.cbStats = cbStats
            self.ctrlStats = ctrlStats
            self.outletStats = outletStats
            self.peripheralStats = peripheralStats

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                cbStats = [raritan.rpc.pdumodel.CircuitBreakerStatistic.decode(x0, agent, useDefaults=useDefaults) for x0 in json['cbStats']] if 'cbStats' in json or not useDefaults else [],
                ctrlStats = [raritan.rpc.pdumodel.CtrlStatistic.decode(x0, agent, useDefaults=useDefaults) for x0 in json['ctrlStats']] if 'ctrlStats' in json or not useDefaults else [],
                outletStats = [raritan.rpc.pdumodel.OutletStatistic.decode(x0, agent, useDefaults=useDefaults) for x0 in json['outletStats']] if 'outletStats' in json or not useDefaults else [],
                peripheralStats = raritan.rpc.peripheral.DeviceManager.Statistics.decode(json['peripheralStats'], agent, useDefaults=useDefaults) if 'peripheralStats' in json or not useDefaults else raritan.rpc.peripheral.DeviceManager.Statistics(),
            )
            return obj

        def encode(self):
            json = {}
            json['cbStats'] = [raritan.rpc.pdumodel.CircuitBreakerStatistic.encode(x0) for x0 in self.cbStats]
            json['ctrlStats'] = [raritan.rpc.pdumodel.CtrlStatistic.encode(x0) for x0 in self.ctrlStats]
            json['outletStats'] = [raritan.rpc.pdumodel.OutletStatistic.encode(x0) for x0 in self.outletStats]
            json['peripheralStats'] = raritan.rpc.peripheral.DeviceManager.Statistics.encode(self.peripheralStats)
            return json

    # enumeration
    class StartupState(Enumeration):
        idlType = "pdumodel.Pdu_6_5_5.StartupState:1.0.0"
        values = ["SS_ON", "SS_OFF", "SS_LASTKNOWN"]

    StartupState.SS_ON = StartupState(0)
    StartupState.SS_OFF = StartupState(1)
    StartupState.SS_LASTKNOWN = StartupState(2)

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Pdu_6_5_5.Settings:1.0.0"
        elements = ["name", "startupState", "cycleDelay", "inRushGuardDelay", "outletPowerStateSequence", "powerOnDelay", "latchingRelays", "energyPulseEnabled", "energyPulsesPerKWh", "demandUpdateInterval", "demandAveragingIntervals", "suspendTripCauseOutlets", "inhibitRelayControl"]

        def __init__(self, name="", startupState=None, cycleDelay=0, inRushGuardDelay=0, outletPowerStateSequence=[], powerOnDelay=0, latchingRelays=False, energyPulseEnabled=False, energyPulsesPerKWh=0, demandUpdateInterval=0, demandAveragingIntervals=0, suspendTripCauseOutlets=False, inhibitRelayControl=False):
            if startupState is None:
                startupState = raritan.rpc.pdumodel.Pdu.StartupState.SS_ON
            if not typecheck._is_int(name):
                typecheck.is_string(name, AssertionError)
            typecheck.is_enum(startupState, raritan.rpc.pdumodel.Pdu.StartupState, AssertionError)
            typecheck.is_int(cycleDelay, AssertionError)
            typecheck.is_int(inRushGuardDelay, AssertionError)
            for x0 in outletPowerStateSequence:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_int(powerOnDelay, AssertionError)
            typecheck.is_bool(latchingRelays, AssertionError)
            typecheck.is_bool(energyPulseEnabled, AssertionError)
            typecheck.is_int(energyPulsesPerKWh, AssertionError)
            typecheck.is_int(demandUpdateInterval, AssertionError)
            typecheck.is_int(demandAveragingIntervals, AssertionError)
            typecheck.is_bool(suspendTripCauseOutlets, AssertionError)
            typecheck.is_bool(inhibitRelayControl, AssertionError)

            self.name = name
            self.startupState = startupState
            self.cycleDelay = cycleDelay
            self.inRushGuardDelay = inRushGuardDelay
            self.outletPowerStateSequence = outletPowerStateSequence
            self.powerOnDelay = powerOnDelay
            self.latchingRelays = latchingRelays
            self.energyPulseEnabled = energyPulseEnabled
            self.energyPulsesPerKWh = energyPulsesPerKWh
            self.demandUpdateInterval = demandUpdateInterval
            self.demandAveragingIntervals = demandAveragingIntervals
            self.suspendTripCauseOutlets = suspendTripCauseOutlets
            self.inhibitRelayControl = inhibitRelayControl

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                name = json['name'] if 'name' in json or not useDefaults else "",
                startupState = raritan.rpc.pdumodel.Pdu.StartupState.decode(json['startupState']) if 'startupState' in json or not useDefaults else raritan.rpc.pdumodel.Pdu.StartupState.SS_ON,
                cycleDelay = json['cycleDelay'] if 'cycleDelay' in json or not useDefaults else 0,
                inRushGuardDelay = json['inRushGuardDelay'] if 'inRushGuardDelay' in json or not useDefaults else 0,
                outletPowerStateSequence = [x0 for x0 in json['outletPowerStateSequence']] if 'outletPowerStateSequence' in json or not useDefaults else [],
                powerOnDelay = json['powerOnDelay'] if 'powerOnDelay' in json or not useDefaults else 0,
                latchingRelays = json['latchingRelays'] if 'latchingRelays' in json or not useDefaults else False,
                energyPulseEnabled = json['energyPulseEnabled'] if 'energyPulseEnabled' in json or not useDefaults else False,
                energyPulsesPerKWh = json['energyPulsesPerKWh'] if 'energyPulsesPerKWh' in json or not useDefaults else 0,
                demandUpdateInterval = json['demandUpdateInterval'] if 'demandUpdateInterval' in json or not useDefaults else 0,
                demandAveragingIntervals = json['demandAveragingIntervals'] if 'demandAveragingIntervals' in json or not useDefaults else 0,
                suspendTripCauseOutlets = json['suspendTripCauseOutlets'] if 'suspendTripCauseOutlets' in json or not useDefaults else False,
                inhibitRelayControl = json['inhibitRelayControl'] if 'inhibitRelayControl' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = str(self.name)
            json['startupState'] = raritan.rpc.pdumodel.Pdu.StartupState.encode(self.startupState)
            json['cycleDelay'] = self.cycleDelay
            json['inRushGuardDelay'] = self.inRushGuardDelay
            json['outletPowerStateSequence'] = [x0 for x0 in self.outletPowerStateSequence]
            json['powerOnDelay'] = self.powerOnDelay
            json['latchingRelays'] = self.latchingRelays
            json['energyPulseEnabled'] = self.energyPulseEnabled
            json['energyPulsesPerKWh'] = self.energyPulsesPerKWh
            json['demandUpdateInterval'] = self.demandUpdateInterval
            json['demandAveragingIntervals'] = self.demandAveragingIntervals
            json['suspendTripCauseOutlets'] = self.suspendTripCauseOutlets
            json['inhibitRelayControl'] = self.inhibitRelayControl
            return json

    # structure
    class OutletSequenceState(Structure):
        idlType = "pdumodel.Pdu_6_5_5.OutletSequenceState:1.0.0"
        elements = ["sequenceRunning", "nextOutletToSwitch", "timeUntilNextSwitch", "outletsRemaining", "cancelableOutletsRemaining"]

        def __init__(self, sequenceRunning=False, nextOutletToSwitch=0, timeUntilNextSwitch=0, outletsRemaining=0, cancelableOutletsRemaining=0):
            typecheck.is_bool(sequenceRunning, AssertionError)
            typecheck.is_int(nextOutletToSwitch, AssertionError)
            typecheck.is_int(timeUntilNextSwitch, AssertionError)
            typecheck.is_int(outletsRemaining, AssertionError)
            typecheck.is_int(cancelableOutletsRemaining, AssertionError)

            self.sequenceRunning = sequenceRunning
            self.nextOutletToSwitch = nextOutletToSwitch
            self.timeUntilNextSwitch = timeUntilNextSwitch
            self.outletsRemaining = outletsRemaining
            self.cancelableOutletsRemaining = cancelableOutletsRemaining

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                sequenceRunning = json['sequenceRunning'] if 'sequenceRunning' in json or not useDefaults else False,
                nextOutletToSwitch = json['nextOutletToSwitch'] if 'nextOutletToSwitch' in json or not useDefaults else 0,
                timeUntilNextSwitch = json['timeUntilNextSwitch'] if 'timeUntilNextSwitch' in json or not useDefaults else 0,
                outletsRemaining = json['outletsRemaining'] if 'outletsRemaining' in json or not useDefaults else 0,
                cancelableOutletsRemaining = json['cancelableOutletsRemaining'] if 'cancelableOutletsRemaining' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['sequenceRunning'] = self.sequenceRunning
            json['nextOutletToSwitch'] = self.nextOutletToSwitch
            json['timeUntilNextSwitch'] = self.timeUntilNextSwitch
            json['outletsRemaining'] = self.outletsRemaining
            json['cancelableOutletsRemaining'] = self.cancelableOutletsRemaining
            return json

    # structure
    class PortWithProperties(Structure):
        idlType = "pdumodel.Pdu_6_5_5.PortWithProperties:1.0.0"
        elements = ["id", "port", "properties"]

        def __init__(self, id="", port=None, properties=None):
            if properties is None:
                properties = raritan.rpc.portsmodel.Port.Properties()
            if not typecheck._is_int(id):
                typecheck.is_string(id, AssertionError)
            typecheck.is_interface(port, raritan.rpc.portsmodel.Port, AssertionError)
            typecheck.is_struct(properties, raritan.rpc.portsmodel.Port.Properties, AssertionError)

            self.id = id
            self.port = port
            self.properties = properties

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                id = json['id'] if 'id' in json or not useDefaults else "",
                port = Interface.decode(json['port'], agent) if 'port' in json or not useDefaults else None,
                properties = raritan.rpc.portsmodel.Port.Properties.decode(json['properties'], agent, useDefaults=useDefaults) if 'properties' in json or not useDefaults else raritan.rpc.portsmodel.Port.Properties(),
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = str(self.id)
            json['port'] = Interface.encode(self.port)
            json['properties'] = raritan.rpc.portsmodel.Port.Properties.encode(self.properties)
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Pdu_6_5_5.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Pdu.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Pdu.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Pdu.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Pdu.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Pdu.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Pdu.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Pdu.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Pdu.Settings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.pdumodel.Pdu.Settings(),
                newSettings = raritan.rpc.pdumodel.Pdu.Settings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.pdumodel.Pdu.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class LoadSheddingModeChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Pdu_6_5_5.LoadSheddingModeChangedEvent:1.0.0"

        def __init__(self, enabled=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Pdu.LoadSheddingModeChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_bool(enabled, AssertionError)

            self.enabled = enabled

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.LoadSheddingModeChangedEvent, self).encode()
            json['enabled'] = self.enabled
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["enabled"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.LoadSheddingModeChangedEvent, self).listElements()
            return elements

    # value object
    class OutletSequenceStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Pdu_6_5_5.OutletSequenceStateChangedEvent:1.0.0"

        def __init__(self, newState=None, source=None):
            super(raritan.rpc.pdumodel.Pdu.OutletSequenceStateChangedEvent, self).__init__(source)
            if newState is None:
                newState = raritan.rpc.pdumodel.Pdu.OutletSequenceState()
            typecheck.is_struct(newState, raritan.rpc.pdumodel.Pdu.OutletSequenceState, AssertionError)

            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.OutletSequenceStateChangedEvent, self).encode()
            json['newState'] = raritan.rpc.pdumodel.Pdu.OutletSequenceState.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                newState = raritan.rpc.pdumodel.Pdu.OutletSequenceState.decode(json['newState'], agent, useDefaults=useDefaults) if 'newState' in json or not useDefaults else raritan.rpc.pdumodel.Pdu.OutletSequenceState(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["newState"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.OutletSequenceStateChangedEvent, self).listElements()
            return elements

    # value object
    class PortAppearedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Pdu_6_5_5.PortAppearedEvent:1.0.0"

        def __init__(self, port=None, source=None):
            super(raritan.rpc.pdumodel.Pdu.PortAppearedEvent, self).__init__(source)
            if port is None:
                port = raritan.rpc.pdumodel.Pdu.PortWithProperties()
            typecheck.is_struct(port, raritan.rpc.pdumodel.Pdu.PortWithProperties, AssertionError)

            self.port = port

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.PortAppearedEvent, self).encode()
            json['port'] = raritan.rpc.pdumodel.Pdu.PortWithProperties.encode(self.port)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                port = raritan.rpc.pdumodel.Pdu.PortWithProperties.decode(json['port'], agent, useDefaults=useDefaults) if 'port' in json or not useDefaults else raritan.rpc.pdumodel.Pdu.PortWithProperties(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["port"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.PortAppearedEvent, self).listElements()
            return elements

    # value object
    class PortDisappearedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Pdu_6_5_5.PortDisappearedEvent:1.0.0"

        def __init__(self, portId="", source=None):
            super(raritan.rpc.pdumodel.Pdu.PortDisappearedEvent, self).__init__(source)
            if not typecheck._is_int(portId):
                typecheck.is_string(portId, AssertionError)

            self.portId = portId

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.PortDisappearedEvent, self).encode()
            json['portId'] = str(self.portId)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                portId = json['portId'] if 'portId' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["portId"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.PortDisappearedEvent, self).listElements()
            return elements

    class _getNameplate(Interface.Method):
        name = 'getNameplate'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Nameplate.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Nameplate, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Pdu.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Pdu.Sensors.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.Sensors, DecodeException)
            return _ret_

    class _getSensorLogger(Interface.Method):
        name = 'getSensorLogger'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.sensors.Logger, DecodeException)
            return _ret_

    class _getAlertedSensorManager(Interface.Method):
        name = 'getAlertedSensorManager'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.sensors.AlertedSensorManager, DecodeException)
            return _ret_

    class _getControllers(Interface.Method):
        name = 'getControllers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Controller, DecodeException)
            return _ret_

    class _getOutlets(Interface.Method):
        name = 'getOutlets'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Outlet, DecodeException)
            return _ret_

    class _getOverCurrentProtectors(Interface.Method):
        name = 'getOverCurrentProtectors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.OverCurrentProtector, DecodeException)
            return _ret_

    class _getInlets(Interface.Method):
        name = 'getInlets'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Inlet, DecodeException)
            return _ret_

    class _getTransferSwitches(Interface.Method):
        name = 'getTransferSwitches'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.TransferSwitch, DecodeException)
            return _ret_

    class _getPeripheralDeviceManager(Interface.Method):
        name = 'getPeripheralDeviceManager'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.peripheral.DeviceManager, DecodeException)
            return _ret_

    class _getBeeper(Interface.Method):
        name = 'getBeeper'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.hmi.InternalBeeper, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Pdu.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.Settings, DecodeException)
            return _ret_

    class _isLoadSheddingActive(Interface.Method):
        name = 'isLoadSheddingActive'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Pdu.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Pdu.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setLoadSheddingActive(Interface.Method):
        name = 'setLoadSheddingActive'

        @staticmethod
        def encode(active):
            typecheck.is_bool(active, AssertionError)
            args = {}
            args['active'] = active
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getFeaturePorts(Interface.Method):
        name = 'getFeaturePorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.portsmodel.Port, DecodeException)
            return _ret_

    class _getSensorPorts(Interface.Method):
        name = 'getSensorPorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.portsmodel.Port, DecodeException)
            return _ret_

    class _getRemoteHubPorts(Interface.Method):
        name = 'getRemoteHubPorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.portsmodel.Port, DecodeException)
            return _ret_

    class _getPorts(Interface.Method):
        name = 'getPorts'

        @staticmethod
        def encode(portType, devType):
            typecheck.is_enum(portType, raritan.rpc.peripheral.PortType, AssertionError)
            typecheck.is_enum(devType, raritan.rpc.portsmodel.Port.DeviceTypeId, AssertionError)
            args = {}
            args['portType'] = raritan.rpc.peripheral.PortType.encode(portType)
            args['devType'] = raritan.rpc.portsmodel.Port.DeviceTypeId.encode(devType)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.Pdu.PortWithProperties.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pdu.PortWithProperties, DecodeException)
            return _ret_

    class _enterRS485ConfigModeAndAssignCtrlBoardAddress(Interface.Method):
        name = 'enterRS485ConfigModeAndAssignCtrlBoardAddress'

        @staticmethod
        def encode(addr):
            typecheck.is_int(addr, AssertionError)
            args = {}
            args['addr'] = addr
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _enterRS485ConfigModeAndAssignSCBoardAddress(Interface.Method):
        name = 'enterRS485ConfigModeAndAssignSCBoardAddress'

        @staticmethod
        def encode(deviceId, addr):
            typecheck.is_int(deviceId, AssertionError)
            typecheck.is_int(addr, AssertionError)
            args = {}
            args['deviceId'] = deviceId
            args['addr'] = addr
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _leaveRS485ConfigMode(Interface.Method):
        name = 'leaveRS485ConfigMode'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setAllOutletPowerStates(Interface.Method):
        name = 'setAllOutletPowerStates'

        @staticmethod
        def encode(pstate):
            typecheck.is_enum(pstate, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            args = {}
            args['pstate'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(pstate)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setMultipleOutletPowerStates(Interface.Method):
        name = 'setMultipleOutletPowerStates'

        @staticmethod
        def encode(outletNumbers, state, respectSequence):
            for x0 in outletNumbers:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_enum(state, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(respectSequence, AssertionError)
            args = {}
            args['outletNumbers'] = [x0 for x0 in outletNumbers]
            args['state'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(state)
            args['respectSequence'] = respectSequence
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cycleAllOutletPowerStates(Interface.Method):
        name = 'cycleAllOutletPowerStates'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cycleMultipleOutletPowerStates(Interface.Method):
        name = 'cycleMultipleOutletPowerStates'

        @staticmethod
        def encode(outletNumbers, respectSequence):
            for x0 in outletNumbers:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_bool(respectSequence, AssertionError)
            args = {}
            args['outletNumbers'] = [x0 for x0 in outletNumbers]
            args['respectSequence'] = respectSequence
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getStatistic(Interface.Method):
        name = 'getStatistic'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Pdu.Statistic.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.Statistic, DecodeException)
            return _ret_

    class _getOutletSequenceState(Interface.Method):
        name = 'getOutletSequenceState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Pdu.OutletSequenceState.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.OutletSequenceState, DecodeException)
            return _ret_

    class _cancelOutletSequence(Interface.Method):
        name = 'cancelOutletSequence'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(Pdu, self).__init__(target, agent)
        self.getNameplate = Pdu._getNameplate(self)
        self.getMetaData = Pdu._getMetaData(self)
        self.getSensors = Pdu._getSensors(self)
        self.getSensorLogger = Pdu._getSensorLogger(self)
        self.getAlertedSensorManager = Pdu._getAlertedSensorManager(self)
        self.getControllers = Pdu._getControllers(self)
        self.getOutlets = Pdu._getOutlets(self)
        self.getOverCurrentProtectors = Pdu._getOverCurrentProtectors(self)
        self.getInlets = Pdu._getInlets(self)
        self.getTransferSwitches = Pdu._getTransferSwitches(self)
        self.getPeripheralDeviceManager = Pdu._getPeripheralDeviceManager(self)
        self.getBeeper = Pdu._getBeeper(self)
        self.getSettings = Pdu._getSettings(self)
        self.isLoadSheddingActive = Pdu._isLoadSheddingActive(self)
        self.setSettings = Pdu._setSettings(self)
        self.setLoadSheddingActive = Pdu._setLoadSheddingActive(self)
        self.getFeaturePorts = Pdu._getFeaturePorts(self)
        self.getSensorPorts = Pdu._getSensorPorts(self)
        self.getRemoteHubPorts = Pdu._getRemoteHubPorts(self)
        self.getPorts = Pdu._getPorts(self)
        self.enterRS485ConfigModeAndAssignCtrlBoardAddress = Pdu._enterRS485ConfigModeAndAssignCtrlBoardAddress(self)
        self.enterRS485ConfigModeAndAssignSCBoardAddress = Pdu._enterRS485ConfigModeAndAssignSCBoardAddress(self)
        self.leaveRS485ConfigMode = Pdu._leaveRS485ConfigMode(self)
        self.setAllOutletPowerStates = Pdu._setAllOutletPowerStates(self)
        self.setMultipleOutletPowerStates = Pdu._setMultipleOutletPowerStates(self)
        self.cycleAllOutletPowerStates = Pdu._cycleAllOutletPowerStates(self)
        self.cycleMultipleOutletPowerStates = Pdu._cycleMultipleOutletPowerStates(self)
        self.getStatistic = Pdu._getStatistic(self)
        self.getOutletSequenceState = Pdu._getOutletSequenceState(self)
        self.cancelOutletSequence = Pdu._cancelOutletSequence(self)

#
# Section generated by IdlC from "PowerMeterController.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class PowerMeterController(Interface):
    idlType = "pdumodel.PowerMeterController:1.2.11"

    ERR_INVALID_PARAM = 1

    ERR_METER_BOARD_BUSY = 2

    # structure
    class ScanResult(Structure):
        idlType = "pdumodel.PowerMeterController_1_2_11.ScanResult:1.0.0"
        elements = ["present", "meterCount"]

        def __init__(self, present=False, meterCount=0):
            typecheck.is_bool(present, AssertionError)
            typecheck.is_int(meterCount, AssertionError)

            self.present = present
            self.meterCount = meterCount

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                present = json['present'] if 'present' in json or not useDefaults else False,
                meterCount = json['meterCount'] if 'meterCount' in json or not useDefaults else 0,
            )
            return obj

        def encode(self):
            json = {}
            json['present'] = self.present
            json['meterCount'] = self.meterCount
            return json

    class _scanMeterBoard(Interface.Method):
        name = 'scanMeterBoard'

        @staticmethod
        def encode(powerMeterId):
            typecheck.is_int(powerMeterId, AssertionError)
            args = {}
            args['powerMeterId'] = powerMeterId
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            result = raritan.rpc.pdumodel.PowerMeterController.ScanResult.decode(rsp['result'], agent, useDefaults=useDefaults)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(result, raritan.rpc.pdumodel.PowerMeterController.ScanResult, DecodeException)
            return (_ret_, result)

    # value object
    class PowerMeterCreatedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeterController_1_2_11.PowerMeterCreatedEvent:1.0.0"

        def __init__(self, powerMeter=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterCreatedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.PowerMeter.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.PowerMeter.Settings()
            typecheck.is_interface(powerMeter, raritan.rpc.pdumodel.PowerMeter, AssertionError)
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)

            self.powerMeter = powerMeter
            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterCreatedEvent, self).encode()
            json['powerMeter'] = Interface.encode(self.powerMeter)
            json['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                powerMeter = Interface.decode(json['powerMeter'], agent) if 'powerMeter' in json or not useDefaults else None,
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent, useDefaults=useDefaults) if 'config' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Config(),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["powerMeter", "config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterCreatedEvent, self).listElements()
            return elements

    # value object
    class PowerMeterDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeterController_1_2_11.PowerMeterDeletedEvent:1.0.0"

        def __init__(self, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.PowerMeter.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.PowerMeter.Settings()
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)

            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterDeletedEvent, self).encode()
            json['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent, useDefaults=useDefaults) if 'config' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Config(),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterDeletedEvent, self).listElements()
            return elements

    # value object
    class PanelCreatedEvent(PowerMeterCreatedEvent):
        idlType = "pdumodel.PowerMeterController_1_2_11.PanelCreatedEvent:1.0.0"

        def __init__(self, panelSettings=None, powerMeter=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PanelCreatedEvent, self).__init__(powerMeter, config, settings, actUserName, actIpAddr, source)
            if panelSettings is None:
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            typecheck.is_struct(panelSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)

            self.panelSettings = panelSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PanelCreatedEvent, self).encode()
            json['panelSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.panelSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['panelSettings'], agent, useDefaults=useDefaults) if 'panelSettings' in json or not useDefaults else raritan.rpc.pdumodel.Panel.PanelSettings(),
                # for pdumodel.PowerMeterController_1_2_11.PowerMeterCreatedEvent
                powerMeter = Interface.decode(json['powerMeter'], agent) if 'powerMeter' in json or not useDefaults else None,
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent, useDefaults=useDefaults) if 'config' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Config(),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["panelSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PanelCreatedEvent, self).listElements()
            return elements

    # value object
    class PanelDeletedEvent(PowerMeterDeletedEvent):
        idlType = "pdumodel.PowerMeterController_1_2_11.PanelDeletedEvent:1.0.0"

        def __init__(self, panelSettings=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PanelDeletedEvent, self).__init__(config, settings, actUserName, actIpAddr, source)
            if panelSettings is None:
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            typecheck.is_struct(panelSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)

            self.panelSettings = panelSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PanelDeletedEvent, self).encode()
            json['panelSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.panelSettings)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['panelSettings'], agent, useDefaults=useDefaults) if 'panelSettings' in json or not useDefaults else raritan.rpc.pdumodel.Panel.PanelSettings(),
                # for pdumodel.PowerMeterController_1_2_11.PowerMeterDeletedEvent
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent, useDefaults=useDefaults) if 'config' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Config(),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent, useDefaults=useDefaults) if 'settings' in json or not useDefaults else raritan.rpc.pdumodel.PowerMeter.Settings(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["panelSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PanelDeletedEvent, self).listElements()
            return elements

    class _getPowerMeters(Interface.Method):
        name = 'getPowerMeters'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = dict([(
                elem['key'],
                Interface.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    class _createPowerMeter(Interface.Method):
        name = 'createPowerMeter'

        @staticmethod
        def encode(config, settings):
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            args = {}
            args['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(config)
            args['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            powerMeter = Interface.decode(rsp['powerMeter'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(powerMeter, raritan.rpc.pdumodel.PowerMeter, DecodeException)
            return (_ret_, powerMeter)

    class _createPanel(Interface.Method):
        name = 'createPanel'

        @staticmethod
        def encode(config, powerMeterSettings, panelSettings):
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(powerMeterSettings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            typecheck.is_struct(panelSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)
            args = {}
            args['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(config)
            args['powerMeterSettings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(powerMeterSettings)
            args['panelSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(panelSettings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            panel = Interface.decode(rsp['panel'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(panel, raritan.rpc.pdumodel.Panel, DecodeException)
            return (_ret_, panel)

    class _deletePowerMeter(Interface.Method):
        name = 'deletePowerMeter'

        @staticmethod
        def encode(powerMeterId):
            typecheck.is_int(powerMeterId, AssertionError)
            args = {}
            args['powerMeterId'] = powerMeterId
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(PowerMeterController, self).__init__(target, agent)
        self.scanMeterBoard = PowerMeterController._scanMeterBoard(self)
        self.getPowerMeters = PowerMeterController._getPowerMeters(self)
        self.createPowerMeter = PowerMeterController._createPowerMeter(self)
        self.createPanel = PowerMeterController._createPanel(self)
        self.deletePowerMeter = PowerMeterController._deletePowerMeter(self)

#
# Section generated by IdlC from "PowerQualitySensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.sensors


# interface
class PowerQualitySensor(raritan.rpc.sensors.StateSensor):
    idlType = "pdumodel.PowerQualitySensor:2.0.7"

    STATE_NORMAL = 0

    STATE_WARNING = 1

    STATE_CRITICAL = 2

#
# Section generated by IdlC from "TypeBResidualCurrentNumericSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.sensors


# interface
class TypeBResidualCurrentNumericSensor(raritan.rpc.sensors.NumericSensor):
    idlType = "pdumodel.TypeBResidualCurrentNumericSensor:1.0.7"

    class _degauss(Interface.Method):
        name = 'degauss'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(TypeBResidualCurrentNumericSensor, self).__init__(target, agent)
        self.degauss = TypeBResidualCurrentNumericSensor._degauss(self)

#
# Section generated by IdlC from "Unit.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class Unit(Interface):
    idlType = "pdumodel.Unit:2.0.1"

    ERR_INVALID_PARAM = 1

    # enumeration
    class Orientation(Enumeration):
        idlType = "pdumodel.Unit_2_0_1.Orientation:1.0.0"
        values = ["NORMAL", "FLIPPED"]

    Orientation.NORMAL = Orientation(0)
    Orientation.FLIPPED = Orientation(1)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Unit_2_0_1.MetaData:1.0.0"
        elements = ["hasOrientationSensor", "supportedDisplayOrientations"]

        def __init__(self, hasOrientationSensor=False, supportedDisplayOrientations=[]):
            typecheck.is_bool(hasOrientationSensor, AssertionError)
            for x0 in supportedDisplayOrientations:
                typecheck.is_enum(x0, raritan.rpc.pdumodel.Unit.Orientation, AssertionError)

            self.hasOrientationSensor = hasOrientationSensor
            self.supportedDisplayOrientations = supportedDisplayOrientations

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                hasOrientationSensor = json['hasOrientationSensor'] if 'hasOrientationSensor' in json or not useDefaults else False,
                supportedDisplayOrientations = [raritan.rpc.pdumodel.Unit.Orientation.decode(x0) for x0 in json['supportedDisplayOrientations']] if 'supportedDisplayOrientations' in json or not useDefaults else [],
            )
            return obj

        def encode(self):
            json = {}
            json['hasOrientationSensor'] = self.hasOrientationSensor
            json['supportedDisplayOrientations'] = [raritan.rpc.pdumodel.Unit.Orientation.encode(x0) for x0 in self.supportedDisplayOrientations]
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Unit_2_0_1.Settings:1.0.0"
        elements = ["buzzerMuted", "autoDisplayOrientation", "displayOrientation"]

        def __init__(self, buzzerMuted=False, autoDisplayOrientation=False, displayOrientation=None):
            if displayOrientation is None:
                displayOrientation = raritan.rpc.pdumodel.Unit.Orientation.NORMAL
            typecheck.is_bool(buzzerMuted, AssertionError)
            typecheck.is_bool(autoDisplayOrientation, AssertionError)
            typecheck.is_enum(displayOrientation, raritan.rpc.pdumodel.Unit.Orientation, AssertionError)

            self.buzzerMuted = buzzerMuted
            self.autoDisplayOrientation = autoDisplayOrientation
            self.displayOrientation = displayOrientation

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                buzzerMuted = json['buzzerMuted'] if 'buzzerMuted' in json or not useDefaults else False,
                autoDisplayOrientation = json['autoDisplayOrientation'] if 'autoDisplayOrientation' in json or not useDefaults else False,
                displayOrientation = raritan.rpc.pdumodel.Unit.Orientation.decode(json['displayOrientation']) if 'displayOrientation' in json or not useDefaults else raritan.rpc.pdumodel.Unit.Orientation.NORMAL,
            )
            return obj

        def encode(self):
            json = {}
            json['buzzerMuted'] = self.buzzerMuted
            json['autoDisplayOrientation'] = self.autoDisplayOrientation
            json['displayOrientation'] = raritan.rpc.pdumodel.Unit.Orientation.encode(self.displayOrientation)
            return json

    # value object
    class IdentificationStartedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Unit_2_0_1.IdentificationStartedEvent:1.0.0"

        def __init__(self, duration=0, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Unit.IdentificationStartedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(duration, AssertionError)

            self.duration = duration

        def encode(self):
            json = super(raritan.rpc.pdumodel.Unit.IdentificationStartedEvent, self).encode()
            json['duration'] = self.duration
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                duration = json['duration'] if 'duration' in json or not useDefaults else 0,
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["duration"]
            elements = elements + super(raritan.rpc.pdumodel.Unit.IdentificationStartedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Unit.MetaData.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Unit.MetaData, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Unit.Settings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Unit.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Unit.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Unit.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _identify(Interface.Method):
        name = 'identify'

        @staticmethod
        def encode(seconds):
            typecheck.is_int(seconds, AssertionError)
            args = {}
            args['seconds'] = seconds
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _muteBuzzer(Interface.Method):
        name = 'muteBuzzer'

        @staticmethod
        def encode(mute):
            typecheck.is_bool(mute, AssertionError)
            args = {}
            args['mute'] = mute
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getDisplayOrientation(Interface.Method):
        name = 'getDisplayOrientation'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.Unit.Orientation.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.pdumodel.Unit.Orientation, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Unit, self).__init__(target, agent)
        self.getMetaData = Unit._getMetaData(self)
        self.getSettings = Unit._getSettings(self)
        self.setSettings = Unit._setSettings(self)
        self.identify = Unit._identify(self)
        self.muteBuzzer = Unit._muteBuzzer(self)
        self.getDisplayOrientation = Unit._getDisplayOrientation(self)

#
# Section generated by IdlC from "VoltageMonitoringSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class VoltageMonitoringSensor(raritan.rpc.sensors.NumericSensor):
    idlType = "pdumodel.VoltageMonitoringSensor:1.0.3"

    # enumeration
    class EventType(Enumeration):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_3.EventType:1.0.0"
        values = ["DIP", "SWELL", "UNKNOWN"]

    EventType.DIP = EventType(0)
    EventType.SWELL = EventType(1)
    EventType.UNKNOWN = EventType(2)
    EventType._fallback = EventType.UNKNOWN

    # structure
    class DipSwellThresholds(Structure):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds:1.0.0"
        elements = ["dipActive", "dipThreshold", "swellActive", "swellThreshold", "deassertionHysteresis"]

        def __init__(self, dipActive=False, dipThreshold=0.0, swellActive=False, swellThreshold=0.0, deassertionHysteresis=0.0):
            typecheck.is_bool(dipActive, AssertionError)
            typecheck.is_double(dipThreshold, AssertionError)
            typecheck.is_bool(swellActive, AssertionError)
            typecheck.is_double(swellThreshold, AssertionError)
            typecheck.is_float(deassertionHysteresis, AssertionError)

            self.dipActive = dipActive
            self.dipThreshold = dipThreshold
            self.swellActive = swellActive
            self.swellThreshold = swellThreshold
            self.deassertionHysteresis = deassertionHysteresis

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                dipActive = json['dipActive'] if 'dipActive' in json or not useDefaults else False,
                dipThreshold = json['dipThreshold'] if 'dipThreshold' in json or not useDefaults else 0.0,
                swellActive = json['swellActive'] if 'swellActive' in json or not useDefaults else False,
                swellThreshold = json['swellThreshold'] if 'swellThreshold' in json or not useDefaults else 0.0,
                deassertionHysteresis = json['deassertionHysteresis'] if 'deassertionHysteresis' in json or not useDefaults else 0.0,
            )
            return obj

        def encode(self):
            json = {}
            json['dipActive'] = self.dipActive
            json['dipThreshold'] = self.dipThreshold
            json['swellActive'] = self.swellActive
            json['swellThreshold'] = self.swellThreshold
            json['deassertionHysteresis'] = self.deassertionHysteresis
            return json

    # structure
    class Event(Structure):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_3.Event:1.0.0"
        elements = ["type", "timestamp", "duration", "voltage", "waveform"]

        def __init__(self, type=None, timestamp=None, duration=0, voltage=0.0, waveform=None):
            if type is None:
                type = raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType.DIP
            if waveform is None:
                waveform = raritan.rpc.pdumodel.Waveform()
            typecheck.is_enum(type, raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType, AssertionError)
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_int(duration, AssertionError)
            typecheck.is_double(voltage, AssertionError)
            typecheck.is_struct(waveform, raritan.rpc.pdumodel.Waveform, AssertionError)

            self.type = type
            self.timestamp = timestamp
            self.duration = duration
            self.voltage = voltage
            self.waveform = waveform

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                type = raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType.DIP,
                timestamp = raritan.rpc.Time.decode(json['timestamp']) if 'timestamp' in json or not useDefaults else None,
                duration = json['duration'] if 'duration' in json or not useDefaults else 0,
                voltage = json['voltage'] if 'voltage' in json or not useDefaults else 0.0,
                waveform = raritan.rpc.pdumodel.Waveform.decode(json['waveform'], agent, useDefaults=useDefaults) if 'waveform' in json or not useDefaults else raritan.rpc.pdumodel.Waveform(),
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType.encode(self.type)
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['duration'] = self.duration
            json['voltage'] = self.voltage
            json['waveform'] = raritan.rpc.pdumodel.Waveform.encode(self.waveform)
            return json

    # value object
    class EventOccurredEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_3.EventOccurredEvent:1.0.0"

        def __init__(self, event=None, source=None):
            super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventOccurredEvent, self).__init__(source)
            if event is None:
                event = raritan.rpc.pdumodel.VoltageMonitoringSensor.Event()
            typecheck.is_struct(event, raritan.rpc.pdumodel.VoltageMonitoringSensor.Event, AssertionError)

            self.event = event

        def encode(self):
            json = super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventOccurredEvent, self).encode()
            json['event'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.Event.encode(self.event)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                event = raritan.rpc.pdumodel.VoltageMonitoringSensor.Event.decode(json['event'], agent, useDefaults=useDefaults) if 'event' in json or not useDefaults else raritan.rpc.pdumodel.VoltageMonitoringSensor.Event(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["event"]
            elements = elements + super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventOccurredEvent, self).listElements()
            return elements

    # value object
    class EventListClearedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_3.EventListClearedEvent:1.0.0"

        def __init__(self, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventListClearedEvent, self).__init__(actUserName, actIpAddr, source)

        def encode(self):
            json = super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventListClearedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventListClearedEvent, self).listElements()
            return elements

    # value object
    class DipSwellThresholdsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholdsChangedEvent:1.0.0"

        def __init__(self, oldThresholds=None, newThresholds=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholdsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldThresholds is None:
                oldThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds()
            if newThresholds is None:
                newThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds()
            typecheck.is_struct(oldThresholds, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, AssertionError)
            typecheck.is_struct(newThresholds, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, AssertionError)

            self.oldThresholds = oldThresholds
            self.newThresholds = newThresholds

        def encode(self):
            json = super(raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholdsChangedEvent, self).encode()
            json['oldThresholds'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.encode(self.oldThresholds)
            json['newThresholds'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.encode(self.newThresholds)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.decode(json['oldThresholds'], agent, useDefaults=useDefaults) if 'oldThresholds' in json or not useDefaults else raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds(),
                newThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.decode(json['newThresholds'], agent, useDefaults=useDefaults) if 'newThresholds' in json or not useDefaults else raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds(),
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldThresholds", "newThresholds"]
            elements = elements + super(raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholdsChangedEvent, self).listElements()
            return elements

    class _getRecentEvents(Interface.Method):
        name = 'getRecentEvents'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.pdumodel.VoltageMonitoringSensor.Event.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.VoltageMonitoringSensor.Event, DecodeException)
            return _ret_

    class _clearRecentEvents(Interface.Method):
        name = 'clearRecentEvents'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getDipSwellThresholds(Interface.Method):
        name = 'getDipSwellThresholds'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, DecodeException)
            return _ret_

    class _setDipSwellThresholds(Interface.Method):
        name = 'setDipSwellThresholds'

        @staticmethod
        def encode(thresholds):
            typecheck.is_struct(thresholds, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, AssertionError)
            args = {}
            args['thresholds'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.encode(thresholds)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(VoltageMonitoringSensor, self).__init__(target, agent)
        self.getRecentEvents = VoltageMonitoringSensor._getRecentEvents(self)
        self.clearRecentEvents = VoltageMonitoringSensor._clearRecentEvents(self)
        self.getDipSwellThresholds = VoltageMonitoringSensor._getDipSwellThresholds(self)
        self.setDipSwellThresholds = VoltageMonitoringSensor._setDipSwellThresholds(self)

# from raritan/rpc/pdumodel/__extend__.py
def download_eto(agent):
    """
    Method to download the eto descriptor

    **parameters**

    :param agent: An agent instance from the device where the eto descriptor should be downloaded
    :return: returns the eto descriptor data

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        eto_desc = pdumodel.download_eto(agent)
        print(eto_desc)
    """
    target = "cgi-bin/eto_desc.cgi"
    return agent.get(target)

def download_powermeter_csv(agent):
    """
    Method to download a CSV list of mains sensor readings for all configured power meters and panels

    **parameters**

    :param agent: An agent instance from the device where the pmc data should be downloaded
    :return: returns the pmc data in csv format

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        pmc_data = pdumodel.download_powermeter_csv(agent)
        print(pmc_data)

    """
    target = "cgi-bin/export_pmc.cgi"
    return agent.get(target)

def download_panel_csv(agent, panelid):
    """
    Method to download the pmc data

    **parameters**

    :param agent: An agent instance from the device where the pmc data should be downloaded
    :param panelid: Get the CSV list of main sensors from this panel id (range from 1 - 8)
    :return: returns the pmc data in csv format

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        pmc_data = pdumodel.download_panel_csv(agent, 1)
        print(pmc_data)

    """
    target = "cgi-bin/export_pmc.cgi?panelid=%i" % panelid
    return agent.get(target)

def upload_pmc_config(agent, data):
    """
    Method to upload pmc config files

    **parameters**, **return**

    :param agent: An agent instance for the device where the config should be uploaded
    :param data: The binary data of the pmc config file
    :return: return upload response

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")

        # read file in binary mode
        cfgFile = open("config.csv", "rb")
        # upload
        resp = pdumodel.upload_pmc_config(agent, cfgFile.read())
        # view response
        print(resp)

    """
    target = "cgi-bin/upload_pmc_config.cgi"
    formdata = dict(data=data, filename="config.csv", formname="config_file", mimetype="application/octet-stream")
    response = agent.form_data_file(target, [formdata])
    return response["body"]
