% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R, R/sf.R
\name{st_geometry}
\alias{st_geometry}
\alias{st_geometry.sfc}
\alias{st_geometry.sf}
\alias{st_geometry.sfg}
\alias{st_geometry<-}
\alias{st_set_geometry}
\alias{st_drop_geometry}
\alias{st_drop_geometry.sf}
\alias{st_drop_geometry.default}
\title{Get, set, replace or rename geometry from an sf object}
\usage{
\method{st_geometry}{sfc}(obj, ...)

st_geometry(obj, ...)

\method{st_geometry}{sf}(obj, ...)

\method{st_geometry}{sfc}(obj, ...)

\method{st_geometry}{sfg}(obj, ...)

st_geometry(x) <- value

st_set_geometry(x, value)

st_drop_geometry(x, ...)

\method{st_drop_geometry}{sf}(x, ...)

\method{st_drop_geometry}{default}(x, ...)
}
\arguments{
\item{obj}{object of class \code{sf} or \code{sfc}}

\item{...}{ignored}

\item{x}{object of class \code{data.frame} or \code{sf}}

\item{value}{object of class \code{sfc}, or \code{character} to set, replace, or rename the geometry of \code{x}}
}
\value{
st_geometry returns an object of class \link{sfc}, a list-column with geometries

\code{st_geometry} returns an object of class \link{sfc}. Assigning geometry to a \code{data.frame} creates an \link{sf} object, assigning it to an \link{sf} object replaces the geometry list-column.
}
\description{
Get, set, replace or rename geometry from an sf object
}
\details{
when applied to a \code{data.frame} and when \code{value} is an object of class \code{sfc}, \code{st_set_geometry} and \code{st_geometry<-} will first check for the existence of an attribute \code{sf_column} and overwrite that, or else look for list-columns of class \code{sfc} and overwrite the first of that, or else write the geometry list-column to a column named \code{geometry}.  In case \code{value} is character and \code{x} is of class \code{sf}, the "active" geometry column is set to \code{x[[value]]}.

the replacement function applied to \code{sf} objects will overwrite the geometry list-column, if \code{value} is \code{NULL}, it will remove it and coerce \code{x} to a \code{data.frame}.

if \code{x} is of class \code{sf}, \code{st_drop_geometry} drops the geometry of its argument, and reclasses it accordingly; otherwise it returns \code{x} unmodified.
}
\examples{
df = data.frame(a = 1:2)
sfc = st_sfc(st_point(c(3,4)), st_point(c(10,11)))
st_geometry(sfc)
st_geometry(df) <- sfc
class(df)
st_geometry(df)
st_geometry(df) <- sfc # replaces
st_geometry(df) <- NULL # remove geometry, coerce to data.frame
sf <- st_set_geometry(df, sfc) # set geometry, return sf
st_set_geometry(sf, NULL) # remove geometry, coerce to data.frame
}
