% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patrick-package.R
\docType{package}
\name{patrick-package}
\alias{patrick}
\alias{patrick-package}
\title{Parameterized Unit Testing}
\description{
`patrick` (parameterized testing in R is kind of cool!) is a `testthat`
extension that lets you create reusable blocks of a test codes. Parameterized
tests are often easier to read and more reliable, since they follow the DNRY
(do not repeat yourself) rule. To do this, define tests with the function
[with_parameters_test_that()]. Multiple approaches are provided for passing
sets of cases.
}
\details{
This package is inspired by parameterized testing packages in other
languages, notably the
[`parameterized`](https://github.com/wolever/parameterized) library in
Python.
}
\examples{
with_parameters_test_that("trigonometric functions match identities:",
  {
    testthat::expect_equal(expr, numeric_value)
  },
  expr = c(sin(pi / 4), cos(pi / 4), tan(pi / 4)),
  numeric_value = c(1 / sqrt(2), 1 / sqrt(2), 1),
  .test_name = c("sin", "cos", "tan")
)

# Run the same test with the cases() constructor
with_parameters_test_that(
  "trigonometric functions match identities",
  {
    testthat::expect_equal(expr, numeric_value)
  },
  cases(
    sin = list(expr = sin(pi / 4), numeric_value = 1 / sqrt(2)),
    cos = list(expr = cos(pi / 4), numeric_value = 1 / sqrt(2)),
    tan = list(expr = tan(pi / 4), numeric_value = 1)
  )
)

# If names aren't provided, they are automatically generated.
with_parameters_test_that(
  "trigonometric functions match identities",
  {
    testthat::expect_equal(expr, numeric_value)
  },
  cases(
    list(expr = sin(pi / 4), numeric_value = 1 / sqrt(2)),
    list(expr = cos(pi / 4), numeric_value = 1 / sqrt(2)),
    list(expr = tan(pi / 4), numeric_value = 1)
  )
)
# The first test case is named "expr=0.7071068, numeric_value="0.7071068"
# and so on.

# Or, pass a data frame of cases, perhaps using a helper function
make_cases <- function() {
  tibble::tribble(
    ~.test_name, ~expr, ~numeric_value,
    "sin", sin(pi / 4), 1 / sqrt(2),
    "cos", cos(pi / 4), 1 / sqrt(2),
    "tan", tan(pi / 4), 1
  )
}

with_parameters_test_that(
  "trigonometric functions match identities",
  {
    testthat::expect_equal(expr, numeric_value)
  },
  .cases = make_cases()
)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/google/patrick}
  \item Report bugs at \url{https://github.com/google/patrick/issues}
}

}
\author{
\strong{Maintainer}: Michael Quinn \email{msquinn@google.com}

Other contributors:
\itemize{
  \item Michael Chirico \email{chiricom@google.com} [contributor]
}

}
\keyword{internal}
