% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-weights.R
\name{frequency_weights}
\alias{frequency_weights}
\title{Frequency weights}
\usage{
frequency_weights(x)
}
\arguments{
\item{x}{An integer vector.}
}
\value{
A new frequency weights vector.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{frequency_weights()} creates a vector of frequency weights which allow you
to compactly repeat an observation a set number of times. Frequency weights
are supplied as a non-negative integer vector, where only whole numbers are
allowed.
}
\details{
Frequency weights are integers that denote how many times a particular row of
the data has been observed. They help compress redundant rows into a single
entry.

In tidymodels, frequency weights are used for all parts of the preprocessing,
model fitting, and performance estimation operations.
}
\examples{
# Record that the first observation has 10 replicates, the second has 12
# replicates, and so on
frequency_weights(c(10, 12, 2, 1))

# Fractional values are not allowed
try(frequency_weights(c(1.5, 2.3, 10)))
}
\seealso{
\code{\link[=importance_weights]{importance_weights()}}
}
