% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-quote-literal.R
\docType{data}
\name{spec_sql_quote_literal}
\alias{spec_sql_quote_literal}
\title{spec_sql_quote_literal}
\value{
\code{dbQuoteLiteral()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty
integer,
numeric,
character,
logical,
date,
time,
or blob vector,
this function returns a length-0 object.

When passing the returned object again to \code{dbQuoteLiteral()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link[DBI:SQL]{DBI::SQL} should also return them unchanged.
(For backends it may be most convenient to return \link[DBI:SQL]{DBI::SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
spec_sql_quote_literal
}
\section{Specification}{

The returned expression can be used in a \verb{SELECT ...} query,
and the value of
\code{dbGetQuery(paste0("SELECT ", dbQuoteLiteral(x)))[[1]]}
must be equal to \code{x}
for any scalar
integer,
numeric,
string,
and logical.
If \code{x} is \code{NA}, the result must merely satisfy \code{\link[=is.na]{is.na()}}.
The literals \code{"NA"} or \code{"NULL"} are not treated specially.

\code{NA} should be translated to an unquoted SQL \code{NULL},
so that the query \verb{SELECT * FROM (SELECT 1) a WHERE ... IS NULL}
returns one row.
}

\section{Failure modes}{


Passing a list
for the \code{x} argument raises an error.
}

\seealso{
Other sql specifications: 
\code{\link{spec_sql_append_table}},
\code{\link{spec_sql_create_table}},
\code{\link{spec_sql_exists_table}},
\code{\link{spec_sql_list_fields}},
\code{\link{spec_sql_list_objects}},
\code{\link{spec_sql_list_tables}},
\code{\link{spec_sql_quote_identifier}},
\code{\link{spec_sql_quote_string}},
\code{\link{spec_sql_read_table}},
\code{\link{spec_sql_remove_table}},
\code{\link{spec_sql_unquote_identifier}},
\code{\link{spec_sql_write_table}}
}
\concept{sql specifications}
