/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QSettings>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "AbstractSeqEdWndDependentDlg.hpp"

namespace MsXpS
{
namespace MassXpert
{


AbstractSeqEdWndDependentDlg::AbstractSeqEdWndDependentDlg(
  SequenceEditorWnd *seq_editor_wnd_p,
  libXpertMassCore::PolymerQSPtr polymer_sp,
  libXpertMassCore::PolChemDefCstSPtr pol_chem_def_csp,
  const QString &config_settings_file_path,
  const QString &wnd_type_name,
  const QString &application_name,
  const QString &description)
  : QDialog(static_cast<QWidget *>(seq_editor_wnd_p)),
    mp_editorWnd(seq_editor_wnd_p),
    msp_polymer(polymer_sp),
    mcsp_polChemDef(pol_chem_def_csp),
    m_configSettingsFilePath(config_settings_file_path),
    m_wndTypeName(wnd_type_name),
    m_applicationName(application_name),
    m_windowDescription(description)
{
  if(!seq_editor_wnd_p)
    qFatal() << "Programming error. Pointer cannot be nullptr.";

  setWindowIcon(qApp->windowIcon());

  // We cannot test for non-0 pointers because the subclasses may not use
  // both pointers or any of them. The only that has to be there and non-0
  // is the pointer to the sequence editor window, which is the rationale of
  // this class.

  setWindowTitle(
    QString("%1 - %2").arg(m_applicationName).arg(m_windowDescription));
}


AbstractSeqEdWndDependentDlg::~AbstractSeqEdWndDependentDlg()
{
}


void
AbstractSeqEdWndDependentDlg::closeEvent([[maybe_unused]] QCloseEvent *event)
{
  // No real close, because we did not ask that
  // close==destruction. Thus we only hide the dialog remembering its
  // position and size.

  writeSettings();
}


void
AbstractSeqEdWndDependentDlg::writeSettings()
{
  QSettings settings(m_configSettingsFilePath, QSettings::IniFormat);

  settings.beginGroup(m_wndTypeName);
  settings.setValue("geometry", saveGeometry());
  settings.endGroup();
}


void
AbstractSeqEdWndDependentDlg::readSettings()
{
  QSettings settings(m_configSettingsFilePath, QSettings::IniFormat);

  settings.beginGroup(m_wndTypeName);
  restoreGeometry(settings.value("geometry").toByteArray());
  settings.endGroup();
}


SequenceEditorWnd *
AbstractSeqEdWndDependentDlg::editorWnd() const
{
  return mp_editorWnd;
}

void
AbstractSeqEdWndDependentDlg::displayWindowTitle()
{
  setWindowTitle(
    QString("%1 - %2").arg(m_applicationName).arg(m_windowDescription));
}


} // namespace MassXpert
} // namespace MsXpS
