// SPDX-License-Identifier: GPL-2.0

use crate::helpers::function_name;
use proc_macro::TokenStream;

/// Please see [`crate::export`] for documentation.
pub(crate) fn export(_attr: TokenStream, ts: TokenStream) -> TokenStream {
    let Some(name) = function_name(ts.clone()) else {
        return "::core::compile_error!(\"The #[export] attribute must be used on a function.\");"
            .parse::<TokenStream>()
            .unwrap();
    };

    // This verifies that the function has the same signature as the declaration generated by
    // bindgen. It makes use of the fact that all branches of an if/else must have the same type.
    let signature_check = quote!(
        const _: () = {
            if true {
                ::kernel::bindings::#name
            } else {
                #name
            };
        };
    );

    let no_mangle = quote!(#[no_mangle]);

    TokenStream::from_iter([signature_check, no_mangle, ts])
}
