#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Titan Quest
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251114.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='titan-quest'
GAME_NAME='Titan Quest'

ARCHIVE_BASE_0_NAME='setup_titan_quest_-_anniversary_edition_2.10.6_(59562).exe'
ARCHIVE_BASE_0_MD5='a8b9399e2f968ca819c7138ff2ce5ab1'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_titan_quest_-_anniversary_edition_2.10.6_(59562)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='7164d6f1cf600aaa17101b4a263d4a70'
ARCHIVE_BASE_0_PART2_NAME='setup_titan_quest_-_anniversary_edition_2.10.6_(59562)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='b8b5821c04bfed43068e02b5a1431511'
ARCHIVE_BASE_0_PART3_NAME='setup_titan_quest_-_anniversary_edition_2.10.6_(59562)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='bb6bcb03b2ef688ef57d46d12d4b1233'
ARCHIVE_BASE_0_PART4_NAME='setup_titan_quest_-_anniversary_edition_2.10.6_(59562)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='2a61ebe44e9424cdbad29f14e072c743'
ARCHIVE_BASE_0_SIZE='13753628'
ARCHIVE_BASE_0_VERSION='2.10.21415-gog59562'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/titan_quest_anniversary_edition'

CONTENT_PATH_DEFAULT='.'
## tq.exe requirements
CONTENT_LIBS_BIN_FILES='
libcurl.dll
THQGDSCore.dll
thqno_api.dll
NatLib.dll
Engine.dll
Game.dll'
## Engine.dll reqirements
CONTENT_LIBS0_BIN_FILES='
DevIL.dll
mss32.dll
binkw32.dll'
## The game crashes on launch if the following library is missing.
CONTENT_LIBS1_BIN_FILES='
THQNOnline/gog/galaxy.dll'
## The intro videos does not play if Direct3D11.dll is missing,
## the game stays stuck on a black screen instead.
CONTENT_LIBS2_BIN_FILES='
Direct3D11.dll'
## Direct3D11.dll requirements
CONTENT_LIBS3_BIN_FILES='
GFSDK_SSAO_D3D11.win32.dll'
CONTENT_GAME_BIN_FILES='
milesredist
settings
maxplugins.dlo
aifeditor.exe
animationcompiler.exe
archivetool.exe
artmanager.exe
bitmapcreator.exe
editor.exe
fbxexporter.exe
fontcompiler.exe
mapcompiler.exe
modelcompiler.exe
pseditor.exe
questeditor.exe
resourcetree.exe
shadercompiler.exe
sourceserver.exe
texturecompiler.exe
tq.exe
viewer.exe'
CONTENT_GAME_DATA_XPACK2_FILES='
resources/quests.arc'
CONTENT_GAME_DATA_RESOURCES_FILES='
resources'
CONTENT_GAME_DATA_FILES='
audio
database
text
toolset
videos
thqnocfg.dat'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/My Games/Titan Quest - Immortal Throne'

APP_MAIN_EXE='tq.exe'
APP_MAIN_OPTIONS='/dx11'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_XPACK2
PKG_DATA_RESOURCES
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_XPACK2
PKG_DATA_RESOURCES'

PKG_DATA_XPACK2_ID="${PKG_DATA_ID}-xpack2"
PKG_DATA_XPACK2_DESCRIPTION='resources shared between the base game and the Raganarök expansion'

PKG_DATA_RESOURCES_ID="${PKG_DATA_ID}-resources"
PKG_DATA_RESOURCES_DESCRIPTION="$PKG_DATA_DESCRIPTION - resources"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	PATH_LIBRARIES_SYSTEM='$(path_libraries)'
	EOF
	cat <<- 'EOF'
	find "$PATH_LIBRARIES_SYSTEM" -iname '*.dll' | while read -r dll_source; do
		dll_destination="${PATH_PREFIX}${dll_source#"${PATH_LIBRARIES_SYSTEM}"}"
	    mkdir --parents "$(dirname "$dll_destination")"
	    ln --symbolic "$dll_source" "$dll_destination"
	done
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
