#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Harry Potter and the Mysterious Thief - Part 1
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240912.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='harry-potter-and-the-mysterious-thief-part-1'
GAME_NAME='Harry Potter and the Mysterious Thief - Part 1'

ARCHIVE_BASE_0_NAME='eng_nc17_HarryPotterAndTheMysteriousThiefpartI-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='0735c70f1836158cd5310c3b5e04b10f'
ARCHIVE_BASE_0_SIZE='170000'
ARCHIVE_BASE_0_VERSION='1.0-itch'
ARCHIVE_BASE_0_URL='https://rivarsstudio.itch.io/hpatmt'

CONTENT_PATH_DEFAULT='HarryPotterAndTheMysteriousThiefpartI-linux/game'
CONTENT_GAME_MAIN_FILES='
cache
archive.rpa'
CONTENT_DOC_MAIN_PATH="${CONTENT_PATH_DEFAULT}/.."
CONTENT_DOC_MAIN_FILES='
README.html'

APP_MAIN_TYPE='renpy'

## Ensure easy upgrades from packages generated with pre-20240912.2 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
harry-potter-and-the-mysterious-thief-part1
harry-potter-and-the-mysterious-thief-part1-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
